//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlutilsgl.h,v 1.4 2004/01/13 17:38:43 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

/** @file gmlutilsgl.h
 *  @brief A set of OGL utitility functions
 * 
 */

#ifndef _GMLUTILSGL_H_
#define _GMLUTILSGL_H_

#include "../math/gmlbbox3.h"
#include "../color/gmlcolor.h"


namespace gml
{
  /** @addtogroup UtilsGL
   * @{
   */

  // Rendering of given bounding box with given color
  void RenderBBox(const gml::BBox3f& bbox, const gml::ColorRGBAf& color);

  /** @} */
} // namespace gml


#endif