//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlutilsgl.cpp,v 1.4 2004/01/13 17:38:43 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#include "../base/gmlcommon.h"
#include "gmlutilsgl.h"
#include <windows.h>
#include <gl/gl.h>

void gml::RenderBBox(const gml::BBox3f& bbox, const gml::ColorRGBAf& color)
{
  glBegin(GL_LINES);

  glColor4fv(color);

  glVertex3f(bbox.vmin.x, bbox.vmin.y, bbox.vmin.z);
  glVertex3f(bbox.vmax.x, bbox.vmin.y, bbox.vmin.z);

  glVertex3f(bbox.vmin.x, bbox.vmin.y, bbox.vmin.z);
  glVertex3f(bbox.vmin.x, bbox.vmax.y, bbox.vmin.z);

  glVertex3f(bbox.vmin.x, bbox.vmin.y, bbox.vmin.z);
  glVertex3f(bbox.vmin.x, bbox.vmin.y, bbox.vmax.z);

  glVertex3f(bbox.vmax.x, bbox.vmax.y, bbox.vmax.z);
  glVertex3f(bbox.vmin.x, bbox.vmax.y, bbox.vmax.z);

  glVertex3f(bbox.vmax.x, bbox.vmax.y, bbox.vmax.z);
  glVertex3f(bbox.vmax.x, bbox.vmin.y, bbox.vmax.z);

  glVertex3f(bbox.vmax.x, bbox.vmax.y, bbox.vmax.z);
  glVertex3f(bbox.vmax.x, bbox.vmax.y, bbox.vmin.z);

  glVertex3f(bbox.vmax.x, bbox.vmax.y, bbox.vmin.z);
  glVertex3f(bbox.vmin.x, bbox.vmax.y, bbox.vmin.z);

  glVertex3f(bbox.vmax.x, bbox.vmax.y, bbox.vmin.z);
  glVertex3f(bbox.vmax.x, bbox.vmin.y, bbox.vmin.z);

  glVertex3f(bbox.vmin.x, bbox.vmin.y, bbox.vmax.z);
  glVertex3f(bbox.vmax.x, bbox.vmin.y, bbox.vmax.z);

  glVertex3f(bbox.vmin.x, bbox.vmin.y, bbox.vmax.z);
  glVertex3f(bbox.vmin.x, bbox.vmax.y, bbox.vmax.z);

  glVertex3f(bbox.vmax.x, bbox.vmin.y, bbox.vmin.z);
  glVertex3f(bbox.vmax.x, bbox.vmin.y, bbox.vmax.z);

  glVertex3f(bbox.vmin.x, bbox.vmax.y, bbox.vmin.z);
  glVertex3f(bbox.vmin.x, bbox.vmax.y, bbox.vmax.z);

  glEnd();
}
