//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlglrc.h,v 1.4 2004/01/13 17:38:43 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

/** @file 
*  @brief Class for operations with GL Win32 context
* 
*/

#ifndef _GMLGLRC_H_
#define _GMLGLRC_H_


namespace gml
{
  /** 
  @addtogroup UtilsGL
  @{
  */


  /**
  @class GLRC
  @brief OpenGL context handling
  @attention Include windows.h before using this file!
  Usage:
  @code
  GLRC glrc;
  // inside window creation
  glrc.Create(wnd);
  // before rendering into window
  glrc.MakeCurrent();
  // ... 
  // display in the screen (in case of double buffering)
  glrc.SwapBuffers();
  // ..
  // delete gl context (may be avoided, because called in destructor anyway)
  glrc.Destroy();
  @endcode
  @todo Add possibility to select pixel format (double/single buffer, stencil, etc)
  */
  class GLRC
  {
    public:
      /// @name Class Construction/Destruction
      /// @{
      GLRC(HWND wnd);     ///< Constructor from Window Handle (HWND)
      GLRC(HDC hdc);      ///< Constructor form Device Context Handle(HDC) 

      /// Destory GL context (also called in destructor)
      void Destroy();

      virtual ~GLRC();    ///< Virtual Destructor
      /// @}

      /// @name Context members
      /// @{

      /// Member, needed to create context. Call this before use of OpenGL
      virtual bool Create();

      /// Member, that return true if opengl is ready to draw
      bool IsCurrent() const;

      /// Prepare current context for use
      bool MakeCurrent();

      /// Call this insted of opengl's swap buffer, at the end of the drawing
      void SwapBuffers();
      /// @}

    protected:

      bool m_created; ///< true inside Create() / Destory() pair
      HWND m_wnd;   ///< Window handle
      HDC m_dc;     ///< Device Context handle
      HGLRC m_glrc;     ///< OpenGL Context handle
  };



  /** @} */
} // namespace gml

#endif