//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlcommongl.h,v 1.5 2004/01/13 17:38:43 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

/** @file gmlcommongl.h
 *  @brief OpenGL helpers
 * 
 */

#ifndef _GMLCOMMONGL_H_
#define _GMLCOMMONGL_H_

#define CHECK_GL \
  ASSERT(glGetError() == GL_NO_ERROR)

namespace gml
{
  /** @addtogroup UtilsGL
   * @{
   */

  /// Return 1 if all extensions listed in origReqExts are supported by GL implementation
  /** Extensions should be separated with spaces, like
   * "GL_ARB_multitexture " "GL_NV_evaluators " "GL_NV_texture_shader "
   */
  int InitGLExtensions(const char* origReqExts);
  /// Return a list of unsupported extensions (should be called after InitGLExtensions)
  const char* GetUnsupportedGLExtensions();


  /** @} */
} // namespace gml

#endif