//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlutils3d.h,v 1.4 2004/01/13 17:38:43 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

/** @file gmlutils3d.h
 *  @brief 3d projections etc (utilities)
 * 
 */
#ifndef _GMLUTILS3D_H_
#define _GMLUTILS3D_H_

#include "gmlviewport.h"
#include "../math/gmlbbox3.h"

namespace gml
{
  /** @addtogroup Utils3D
   * @{
   */

  void CalculateClipPlanes(const Viewport& view,
                           const BBox3d& domain,
                           double& p_near,
                           double& p_far);

  /** @} */
} // namespace gml



#endif