//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlutils3d.cpp,v 1.4 2004/01/13 17:38:43 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#include "../base/gmlcommon.h"
#include "gmlutils3d.h"
#include "../math/gmlmatrix4.h"

void gml::CalculateClipPlanes(const Viewport& view,
                              const BBox3d& domain,
                              double& p_near,
                              double& p_far)
{
  Vector3d p;

  // view matrix
  Matrix4x4d vmtx = view.GetTransform();

  // find nearest and firthest of 8 points
  p.SetValue(domain.vmin.x, domain.vmin.y, domain.vmin.z);
  vmtx.MultMatrixVec(p);
  p_near = p_far = -p.z;

  p.SetValue(domain.vmax.x, domain.vmin.y, domain.vmin.z);
  vmtx.MultMatrixVec(p);
  if (-p.z < p_near)
    p_near = -p.z;
  else if (-p.z > p_far)
    p_far = -p.z;

  p.SetValue(domain.vmin.x, domain.vmax.y, domain.vmin.z);
  vmtx.MultMatrixVec(p);
  if (-p.z < p_near)
    p_near = -p.z;
  else if (-p.z > p_far)
    p_far = -p.z;

  p.SetValue(domain.vmax.x, domain.vmax.y, domain.vmin.z);
  vmtx.MultMatrixVec(p);
  if (-p.z < p_near)
    p_near = -p.z;
  else if (-p.z > p_far)
    p_far = -p.z;

  p.SetValue(domain.vmin.x, domain.vmin.y, domain.vmax.z);
  vmtx.MultMatrixVec(p);
  if (-p.z < p_near)
    p_near = -p.z;
  else if (-p.z > p_far)
    p_far = -p.z;

  p.SetValue(domain.vmax.x, domain.vmin.y, domain.vmax.z);
  vmtx.MultMatrixVec(p);
  if (-p.z < p_near)
    p_near = -p.z;
  else if (-p.z > p_far)
    p_far = -p.z;

  p.SetValue(domain.vmin.x, domain.vmax.y, domain.vmax.z);
  vmtx.MultMatrixVec(p);
  if (-p.z < p_near)
    p_near = -p.z;
  else if (-p.z > p_far)
    p_far = -p.z;

  p.SetValue(domain.vmax.x, domain.vmax.y, domain.vmax.z);
  vmtx.MultMatrixVec(p);
  if (-p.z < p_near)
    p_near = -p.z;
  else if (-p.z > p_far)
    p_far = -p.z;

  p_far = Max(1.00, p_far);
  p_near = Min(Max(p_near, p_far / 80.0), p_far / 10.0);
}