//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlframecounter.cpp,v 1.6 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#include "../base/gmlcommon.h"
#include "../math/gmlmath.h"
#include "gmlframecounter.h"

#include "windows.h"
#include "mmsystem.h"

using namespace gml;

FrameCounter::FrameCounter()
{
  // Init member variables
  m_update_speed = 250;
  m_min_frames = 2;
  Reset();
}

FrameCounter::~FrameCounter()
{
}

void FrameCounter::Reset()
{
  m_last_update = GetTickCount();
  m_last_second = m_last_update;
  m_current_frames = 0;
  m_frame_count = 0;
  m_total_frames_time = 0;
  m_updated = true;
}
double FrameCounter::GetFrameCount() const
{
  // Return the last framecount
  return m_frame_count;
}

void FrameCounter::FrameStarted()
{
  m_last_second = GetTickCount();
}

void FrameCounter::FrameFinished()
{
  m_updated = false;

  m_total_frames_time += GetTickCount() - m_last_second;
  int update_time_elapsed = GetTickCount() - m_last_update;

  if (m_current_frames >= m_min_frames && update_time_elapsed > m_update_speed)
  {
    // Set the new FPS value
    if (gml::MathD::NearZero(m_total_frames_time))
    {
      m_frame_count = 0;
      m_frame_time = 0;
    }
    else
    {
      m_frame_count = (double)
                      m_current_frames * (1000.0 / m_total_frames_time);
      m_frame_time = (double) m_total_frames_time / (m_current_frames);
      // Clear current frames
      m_current_frames = 0;
      m_total_frames_time = 0;
    }

    m_updated = true;
  }

  ++m_current_frames;
}

bool FrameCounter::Updated() const
{
  return m_updated;
}


double FrameCounter::GetMeanFrameTime() const
{
  return m_frame_time;
}
