//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlsocket.h,v 1.8 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifndef GMLSOCKET_H_INCLUDED
#define GMLSOCKET_H_INCLUDED

/** @file gmlsocket.h
 *  @brief Windows sockets handling (Win32 API)
 *
 */

#include <string>

namespace gml
{
  /** @addtogroup Net
   *  @{
   */

  /// A wrapper for Win32 stream socket
  class Socket
  {
    private:
      Socket(const Socket& rSrc);         // no implementation
      void operator=(const Socket& rSrc);  // no implementation

    public:

      Socket();
      ~Socket();

      /// Initilize Win32 sockets (MUST be called before use of sockets)
      static bool InitSockets();

      bool Create(int nSocketPort = 0, const char* lpszSocketAddress = NULL);

      bool Bind(int nSocketPort, const char* lpszSocketAddress = NULL);

      void Close();

      bool Connect(const char* lpszHostAddress, int nHostPort);

      bool Accept(gml::Socket& rConnectedSocket);

      bool Listen(int nConnectionBacklog = 5);

      int Receive(void* lpBuf, int nBufLen, int nFlags = 0);

      int Send(const void* lpBuf, int nBufLen, int nFlags = 0);


      bool SendFile(const std::string& out_filename);
      bool ReceiveFile(const std::string in_filename);

    private:

      SOCKET sock;
  };

  /** @} */
} // namespace gml


#endif
