//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlsocket.cpp,v 1.8 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#include "../base/gmlcommon.h"

#include "winsock2.h"
#include "gmlsocket.h"

#include "../files/gmlfile.h"

using namespace gml;


/// Initilize Win32 sockets (MUST be called before use of sockets)
bool Socket::InitSockets()
{
  // initialize Winsock library

  WSADATA wsaData;
  LPWSADATA lpwsaData = NULL;

  if (lpwsaData == NULL)
    lpwsaData = &wsaData;

  WORD wVersionRequested = MAKEWORD(1, 1);
  int nResult = WSAStartup(wVersionRequested, lpwsaData);
  if (nResult != 0)
    return FALSE;

  if (LOBYTE(lpwsaData->wVersion) != 1 || HIBYTE(lpwsaData->wVersion) != 1)
  {
    WSACleanup();
    return false;
  }

  return true;
}

Socket::Socket()
{
  sock = INVALID_SOCKET;
}

Socket::~Socket()
{
  Close();
}



bool Socket::Create(int nSocketPort /*= 0*/,
                    const char* lpszSocketAddress /*= NULL*/)
{
  sock = ::socket(PF_INET, SOCK_STREAM, 0);
  ASSERT(sock != INVALID_SOCKET);

  return Bind(nSocketPort, lpszSocketAddress);
}

bool Socket::Bind(int nSocketPort, const char* lpszSocketAddress /*= NULL */)
{
  SOCKADDR_IN sockAddr;
  memset(&sockAddr, 0, sizeof(sockAddr));

  LPSTR lpszAscii = (LPTSTR) lpszSocketAddress;
  sockAddr.sin_family = AF_INET;

  if (lpszAscii == NULL)
    sockAddr.sin_addr.s_addr = htonl(INADDR_ANY);
  else
  {
    DWORD lResult = inet_addr(lpszAscii);
    if (lResult == INADDR_NONE)
    {
      WSASetLastError(WSAEINVAL);
      return FALSE;
    }
    sockAddr.sin_addr.s_addr = lResult;
  }

  sockAddr.sin_port = htons((u_short) nSocketPort);



  return ::bind(sock, (SOCKADDR *) &sockAddr, sizeof(sockAddr)) !=
         SOCKET_ERROR;
}

void Socket::Close()
{
  if (sock != INVALID_SOCKET)
  {
    closesocket(sock);
    sock = INVALID_SOCKET;
  }
}

bool Socket::Connect(const char* lpszHostAddress, int nHostPort)
{
  ASSERT(lpszHostAddress != NULL);

  SOCKADDR_IN sockAddr;
  memset(&sockAddr, 0, sizeof(sockAddr));

  LPSTR lpszAscii = (LPTSTR) lpszHostAddress;
  sockAddr.sin_family = AF_INET;
  sockAddr.sin_addr.s_addr = inet_addr(lpszAscii);

  if (sockAddr.sin_addr.s_addr == INADDR_NONE)
  {
    LPHOSTENT lphost;
    lphost = gethostbyname(lpszAscii);
    if (lphost != NULL)
      sockAddr.sin_addr.s_addr = ((LPIN_ADDR) lphost->h_addr)->s_addr;
    else
    {
      WSASetLastError(WSAEINVAL);
      return FALSE;
    }
  }

  sockAddr.sin_port = htons((u_short) nHostPort);

  return ::connect(sock, (SOCKADDR *) &sockAddr, sizeof(sockAddr)) !=
         SOCKET_ERROR;
}

bool Socket::Accept(gml::Socket& rConnectedSocket)
{
  rConnectedSocket.sock = INVALID_SOCKET;
  SOCKET hTemp = ::accept(sock, NULL, NULL);

  if (hTemp == INVALID_SOCKET)
    return false;

  rConnectedSocket.sock = hTemp;
  return true;
}

bool Socket::Listen(int nConnectionBacklog /*= 5*/)
{
  return ::listen(sock, nConnectionBacklog) != SOCKET_ERROR ;
}

int Socket::Receive(void* lpBuf, int nBufLen, int nFlags /*= 0 */)
{
  int received_so_far = 0;
  BYTE* buf_ptr = (BYTE*) lpBuf;

  while (received_so_far < nBufLen)
  {
    int size = ::recv(sock, (LPSTR) buf_ptr, nBufLen - received_so_far, nFlags);
    if (size == SOCKET_ERROR)
      return SOCKET_ERROR;

    buf_ptr += size;
    received_so_far += size;
  }

  return  nBufLen;
}

int Socket::Send(const void* lpBuf, int nBufLen, int nFlags /*= 0*/)
{
  return ::send(sock, (LPSTR) lpBuf, nBufLen, nFlags);
}

const int BUFFER_SIZE = 5000;

bool Socket::SendFile(const std::string& out_filename)
{
  gml::File f(out_filename);
  if (!f.Open("rb"))
    return false;

  /*
  // send size of the file first
  int fsize = f.FileSize();
  Send(&fsize, sizeof(fsize));
  if (fsize == 0)
    return true;
  */

  int bytes = 0;
  BYTE* buffer = new BYTE[BUFFER_SIZE];

  int out_size = 0;
  f.Read(buffer, BUFFER_SIZE, out_size);
  do
  {
    bytes = Send(buffer, out_size);
    ASSERT(bytes = out_size);
    f.Read(buffer, BUFFER_SIZE, out_size);
  }
  while (out_size > 0); // there is something to send


  delete[] buffer;

  return true;
}

bool Socket::ReceiveFile(const std::string in_filename)
{
  gml::File f(in_filename);
  if (!f.Open("wb"))
    return false;

  /*
  // receieve size of the file first
  int fsize = -1;
  Receive(&fsize, sizeof(fsize));
  if (fsize == 0)
    return true;
  */

  int bytes = 0;

  BYTE* buffer = new BYTE[BUFFER_SIZE];

  for (; ;)
  {
    int in_size = Receive(buffer, BUFFER_SIZE);
    if (in_size == 0)
    {
      break;
    }

    f.Write(buffer, in_size);
  }

  f.Close();

  delete[] buffer;

  return true;
}