//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: test_ref.cpp,v 1.4 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#include "../base/gmlcommon.h"
#include "../base/gmlref.h"
#include "../base/gmlsmartobject.h"

class MyObject : public gml::SmartObject
{
  public:
    void F()
    {
    }
};


class MySecondObject : public gml::SmartObject
{
  public:

    void SetObject(MyObject* obj)
    {
      m_obj = obj;
    }

    MyObject* GetObject() const
    {
      return m_obj;
    }

  private:

    gml::Ref<MyObject> m_obj;
};

void test_ref()
{
  gml::Ref<MyObject> obj_ref = new MyObject;
  gml::Ref<MyObject> obj_ref2 = obj_ref;

  obj_ref->F();

  gml::Ref<MySecondObject> sec_obj_ref = new MySecondObject;
  sec_obj_ref->SetObject(obj_ref);

  // Object is deleted because there is only one reference to it
  // But obj_ref is not deleted, because obj_ref is also points to it!
  sec_obj_ref.Clear();

  // here objects MyObject is deleted automatically
}
