//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: test_matrix4x4.cpp,v 1.5 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#include "../base/gmlcommon.h"
#include "../math/gmlmatrix4.h"

void test_matrix44()
{
  gml::Matrix4x4d mat1;

  gml::Matrix4x4d mat2(10);

  ASSERT(mat2(0, 0) == 10 &&
         mat2(0, 0) == mat2(1, 1) &&
         mat2(1, 1) == mat2(2, 2) &&
         mat2(2, 2) == mat2(3, 3));


  double mat_array[16] =
  {
    1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16
  };

  gml::Matrix4x4d mat3(mat_array);

  ASSERT(mat3(0, 0) == 1 &&
         mat3(1, 0) == 2 &&
         mat3(2, 0) == 3 &&
         mat3(3, 0) == 4 &&
         mat3(0, 1) == 5 &&
         mat3(1, 1) == 6 &&
         mat3(2, 1) == 7 &&
         mat3(3, 1) == 8 &&
         mat3(0, 2) == 9 &&
         mat3(1, 2) == 10 &&
         mat3(2, 2) == 11 &&
         mat3(3, 2) == 12 &&
         mat3(0, 3) == 13 &&
         mat3(1, 3) == 14 &&
         mat3(2, 3) == 15 &&
         mat3(3, 3) == 16);

  gml::Matrix4x4d mat4(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16);

  ASSERT(mat4(0, 0) == 1 &&
         mat4(0, 1) == 2 &&
         mat4(0, 2) == 3 &&
         mat4(0, 3) == 4 &&
         mat4(1, 0) == 5 &&
         mat4(1, 1) == 6 &&
         mat4(1, 2) == 7 &&
         mat4(1, 3) == 8 &&
         mat4(2, 0) == 9 &&
         mat4(2, 1) == 10 &&
         mat4(2, 2) == 11 &&
         mat4(2, 3) == 12 &&
         mat4(3, 0) == 13 &&
         mat4(3, 1) == 14 &&
         mat4(3, 2) == 15 &&
         mat4(3, 3) == 16);


  const double* val = mat3.GetValue();
  ASSERT(val[15] == 16);

  mat4.SetValue(mat_array);

  ASSERT(mat4(0, 0) == 1 &&
         mat4(1, 0) == 2 &&
         mat4(2, 0) == 3 &&
         mat4(3, 0) == 4 &&
         mat4(0, 1) == 5 &&
         mat4(1, 1) == 6 &&
         mat4(2, 1) == 7 &&
         mat4(3, 1) == 8 &&
         mat4(0, 2) == 9 &&
         mat4(1, 2) == 10 &&
         mat4(2, 2) == 11 &&
         mat4(3, 2) == 12 &&
         mat4(0, 3) == 13 &&
         mat4(1, 3) == 14 &&
         mat4(2, 3) == 15 &&
         mat4(3, 3) == 16);

  mat4.SetValue(10);

  ASSERT(mat4(0, 0) == 10 &&
         mat4(0, 0) == mat4(1, 1) &&
         mat4(1, 1) == mat4(2, 2) &&
         mat4(2, 2) == mat4(3, 3));


  gml::Matrix4x4d mat5 = gml::Matrix4x4d::Identity();
  gml::Matrix4x4f mat6 = gml::Matrix4x4f::Identity();
};
