//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: main.cpp,v 1.10 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#include <base/gmlcommon.h>
#include <math/gmlvector2.h>
#include <base/gmlstring.h>
#include <files/gmlpathstring.h>
#include <math/gmlbbox3.h>
#include <math/gmlbsphere3.h>

#include "main.h"

using namespace gml;

int main()
{
  test_ref();
  test_matrix44();
  test_bitmap();
  // vector testing

  Vector2f vec;
  Vector2f vec1(10);
  Vector2f vec2(10, 20);
  Vector2f vec3(vec2);
  const Vector2f vec4(vec3);

  float a1 = vec3[0];

  const float a3 = vec4[0];
  const float& a4 = vec4[1];

  float* a5 = (float*) vec3;
  const float* a6 = (const float*) vec4;

  vec3.SetValue(3);
  vec3.SetValue(1.0f, 10.0f);


  vec2 += vec1;
  vec2 -= vec1;

  vec1 *= 5;
  vec1 /= 5;

  vec2 = 5.0f * vec1;
  vec3 = vec2 / 10;


  if (vec1 == vec2)
  {
  }

  if (vec1 != vec2)
  {
  }
  double len = vec3.Length();
  double len2 = vec3.SqrLength();

  vec3.Negate();
  vec1 = -vec3;

  double dot = vec1* vec3;
  double cross = vec1 ^ vec3;


  vec1.Clip(0.0f, 0.001f);
  vec1.Normalize();

  if (vec1.Normalized())
  {
    vec1 *= 100;
  }
  len = Length(vec3);
  len2 = SqrLength(vec3);

  float a7[2] =
  {
    1.f, 2.f
  };
  Vector2f& vec5 = Vector2f::Cast(a7);

  const float a8[2] =
  {
    1.f, 2.f
  };
  const Vector2f& vec6 = Vector2f::Cast(a8);

  vec2.SetValue(0.2, 0.3);
  double c = Cos(vec1, vec2);
  double s = Sin(vec1, vec2);

  Vector2i veci;
  Vector2s vecs;

  veci = ConvI(vec1);
  vecs = ConvS(vec1);

  vec1 = ConvF(veci) + ConvF(vecs);

  Vector2d norm_vec = ~veci;
  veci.Normalize();
  // string testing

  String str("asd");

  str.Format("%d %f %s", 123, 1.0f, "asdf");
  //  CString sc = str.AsCString();

  //str = "asdf";
  int l = str.length();
  if (str.find("0") == string::npos)
  {
    str = "nothing";
  }

  int num_str = str.AsInt();


  string a;
  PathString ps1;
  PathString ps(ps1);

  string us, ss, ts;
  String us1, ss1, ts1;

  us = ss + ts;


  BSphere3f bs, bs1;
  Vector3f vec3d(0, 0, 0);

  bs.Include(vec3d);
  bs1.Include(bs);
  return 0;
}

