//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlsimpleimageloader.h,v 1.9 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifndef _GMLIMAGELOADER_H_
#define _GMLIMAGELOADER_H_

// internal headers
#include "../bitmap/gmlimageloader.h"
#include <vector>

namespace gml
{
  /** @addtogroup Images
   *  @{
   */

  /// Image loader based on FreeImage third-party library
  class SimpleImageLoader : public ImageLoader
  {
      /// EXIF  JPEG
      std::vector <unsigned char> m_pcJpegAPP1;

    public:

      virtual bool EnumerateLoadableFormats(void (*f) (IMAGE_FORMAT f));
      virtual bool EnumerateSaveableFormats(void (*f) (IMAGE_FORMAT f));

      virtual IMAGE_FORMAT CheckBitMapFile(const std::string& path);

      virtual bool LoadBitMap(const std::string& path,
                              Image& out_bitmap,
                              IMAGE_FORMAT format = FORMAT_UNKNOWN,
                              int flags = 0);

      virtual bool SaveBitMap(const std::string& path,
                              const Image& bitmap,
                              IMAGE_FORMAT format = FORMAT_UNKNOWN,
                              int in_iQuality = 100,
                              int flags = 0);

      //   EXIF  JPEG
      virtual void GetExifMarker(std::vector <unsigned char>& out_pcData);
      virtual void SetExifMarker(std::vector <unsigned char>& in_pcData);

    private:
      bool LoadPNG(const std::string& path, Image& out_bitmap);
      bool LoadJPG(const std::string& path,
                   Image& out_bitmap,
                   bool in_bReadEXIF = false);
      bool LoadBMP(const std::string& path, Image& out_bitmap);

      bool SavePNG(const std::string& path, const Image& out_bitmap);
      bool SaveJPG(const std::string& path,
                   const Image& out_bitmap,
                   int in_iQuality,
                   bool in_bWriteEXIF = false);
      bool SaveBMP(const std::string& path, const Image& out_bitmap);
  };

  /** @} */
} // namespace gml


#endif