//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlsimpleimage.cpp,v 1.19 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifdef GML_USE_MFC
#include <afxwin.h>
#endif
#include "../../base/gmlcommon.h"
#include "gmlsimpleimage.h"
#include "filters/gmlfilterrgb2bgr.h"
#include <memory.h>

using gml::Image;
using gml::SimpleImage;
using gml::ImageFilter;

SimpleImage::SimpleImage()
  // Creates an empty bitmap.
{
  ConstructorInitLocals();
  Create(1, 1, F_RGB, R_BYTE);
}

void SimpleImage::ConstructorInitLocals()
{
  m_pBits = NULL;
}

SimpleImage::~SimpleImage()
{
  // Free the memory.
  FreeMembers();
}


long SimpleImage::GetMemUsed()
  // Returns the memory used by the object.
{
  return GetMemNeeded(GetWidth(), GetHeight(), GetFormat(), GetRepres()) +
         sizeof(*this);
}


long SimpleImage::GetBytesPerLine() const 
  // Returns number of bytes used per line.
{
  // bdelmee code change
  int nBytes = GetWidth() * ElemSize(m_format, m_repres);
  return nBytes;
}


/////////////////////////////////////////////////////////////////////
// Static functions

long SimpleImage::GetBitsMemNeeded(int width, int height, FORMAT f, REPRES r)
  // Returns memory needed by bitmap bits.
{
  // Calculate memory per line.
  int LineMem = width* ElemSize(f, r);

  // Multiply by number of lines
  return LineMem * height;
}


long SimpleImage::GetMemNeeded(int width, int height, FORMAT f, REPRES r)
  // Returns memory needed by a bitmap with the specified attributes.
{
  int HeaderMem = sizeof(SimpleImage);
  return HeaderMem + GetBitsMemNeeded(width, height, f, r);
}


/////////////////////////////////////////////////////////////////////
// Local functions


bool SimpleImage::InternalCreate(int Width,
                                 int Height,
                                 FORMAT format,
                                 REPRES repres,
                                 ORIENT orient)
  // Create a new empty bitmap. Bits are uninitialized.
  // Assumes that no memory is allocated before the call.
{
  m_pBits = new BYTE[GetBitsMemNeeded(Width, Height, format, repres)];
  InitLocals(Width, Height, format, repres, orient);

  return true;
}


void SimpleImage::InitLineArray()
{
  //  m_pLineArray = (PLBYTE **) malloc (m_Height * sizeof (PLBYTE *));
  m_line_array = new BYTE * [m_height];
  int LineLen = GetBytesPerLine();

  BYTE* pBits = m_pBits;


  for (int y = 0; y <= m_height - 1; ++y, pBits += LineLen)
  {
    m_line_array[y] = pBits;
  }
}

void SimpleImage::FreeMembers()
{
  delete[] m_pBits;
  m_pBits = NULL;

  delete[] m_line_array;
  m_line_array = NULL;
}


void SimpleImage::InternalChangeOrientation(ORIENT new_orient)
{
  if (m_orient == new_orient)
    return; // change nothing

  // since we've got only two orientations, the code is the same for changing one to another
  // FIXME is this OK?
  for (int y = 0; y < m_height / 2; ++y)
  {
    BYTE* line1 = m_line_array[y];
    BYTE* line2 = m_line_array[m_height - y - 1];
    for (int x = 0; x < GetBytesPerLine() ; ++x, ++line1, ++line2)
    {
      std::swap(*line1, *line2);
    }
  }

  m_orient = new_orient;
}


// Draw surface

gml::DrawSurface* SimpleImage::GetDrawSurface()
{
  return NULL; // Not implemented
}
