//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlintelsurface.cpp,v 1.6 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#include "../../base/gmlcommon.h"
#include "gmlintelimage.h"
#include "gmlintelsurface.h"
#include <cv.h>

using gml::IntelImage;
using gml::IntelSurface;

IntelSurface::IntelSurface(IntelImage* in_pImage) : m_pImage(in_pImage)
{
  ASSERT(m_pImage);
}


IntelSurface::~IntelSurface()
{
}

//===================================================================
//= Function name : CreatePen
//= Description   : 
//= Return type   : void  
//===================================================================

int IntelSurface::GetColor(gml::Color3ub in_Color)
{
  int Result = 0;
  // Create pen
  switch (m_pImage->GetFormat())
  {
    case Image::F_BGR:
      Result = CV_RGB(in_Color.r, in_Color.g, in_Color.b);
      break;
    case Image::F_RGB:
      Result = CV_RGB(in_Color.b, in_Color.g, in_Color.r);
      break;
    case Image::F_L:
      Result = CV_RGB(in_Color.r, in_Color.r, in_Color.r);
      break;
  }

  return Result;
}


//===================================================================
//= Function name : DrawLine
//= Description   : 
//= Return type   : void  
//===================================================================

void IntelSurface::DrawLine(int in_iX0,
                            int in_iY0,
                            int in_iX1,
                            int in_iY1,
                            gml::Color3ub in_Color)
{
  int iColor = GetColor(in_Color);

  cvLine(m_pImage->GetImage(),
         cvPoint(in_iX0, in_iY0),
         cvPoint(in_iX1, in_iY1),
         iColor);
}

//===================================================================
//= Function name : DrawLine
//= Description   : 
//= Return type   : void  
//===================================================================

void IntelSurface::DrawLine(gml::Vector2i in_vStart,
                            gml::Vector2i in_vEnd,
                            gml::Color3ub in_Color)
{
  DrawLine(in_vStart.x, in_vStart.y, in_vEnd.x, in_vEnd.y, in_Color);
}

//===================================================================
//= Function name : FrameRect
//= Description   : 
//= Return type   : void  
//===================================================================

void IntelSurface::FrameRect(int in_iX0,
                             int in_iY0,
                             int in_iX1,
                             int in_iY1,
                             gml::Color3ub in_Color)
{
  int iColor = GetColor(in_Color);

  cvRectangle(m_pImage->GetImage(),
              cvPoint(in_iX0, in_iY0),
              cvPoint(in_iX1, in_iY1),
              iColor);
}

//===================================================================
//= Function name : FrameRect
//= Description   : 
//= Return type   : void  
//===================================================================

void IntelSurface::FrameRect(gml::Vector2i in_vStart,
                             gml::Vector2i in_vEnd,
                             gml::Color3ub in_Color)
{
  FrameRect(in_vStart.x, in_vStart.y, in_vEnd.x, in_vEnd.y, in_Color);
}


//===================================================================
//= Function name : FrameRect
//= Description   : 
//= Return type   : void  
//===================================================================

void IntelSurface::Circle(int in_iX0,
                          int in_iY0,
                          int in_iRadius,
                          gml::Color3ub in_Color)
{
  int iColor = GetColor(in_Color);

  cvCircle(m_pImage->GetImage(), cvPoint(in_iX0, in_iY0), in_iRadius, iColor);
}

//===================================================================
//= Function name : FrameRect
//= Description   : 
//= Return type   : void  
//===================================================================

void IntelSurface::Circle(gml::Vector2i in_vCenter,
                          int in_iRadius,
                          gml::Color3ub in_Color)
{
  Circle(in_vCenter.x, in_vCenter.y, in_iRadius, in_Color);
}

//===================================================================
//= Function name : FrameRect
//= Description   : 
//= Return type   : void  
//===================================================================

void IntelSurface::PolyLine(gml::Vector2i* in_pVectors,
                            int in_iPoints,
                            gml::Color3ub in_Color)
{
  int iColor = GetColor(in_Color);
  std::vector<CvPoint> vPoints;
  CvPoint* pPoint;

  // Fill points array
  vPoints.resize(in_iPoints);
  for (int i = 0; i < in_iPoints; i++)
  {
    vPoints[i] = cvPoint(in_pVectors[i].x, in_pVectors[i].y);
  }

  pPoint = &vPoints[0];
  // Draw
  cvPolyLine(m_pImage->GetImage(), &pPoint, &in_iPoints, 1, 0, iColor);
}

void IntelSurface::PolyGon(gml::Vector2i* in_pVectors,
                           int in_iPoints,
                           gml::Color3ub in_Color)
{
  int iColor = GetColor(in_Color);
  std::vector<CvPoint> vPoints;
  CvPoint* pPoint;

  // Fill points array
  vPoints.resize(in_iPoints);
  for (int i = 0; i < in_iPoints; i++)
  {
    vPoints[i] = cvPoint(in_pVectors[i].x, in_pVectors[i].y);
  }

  pPoint = &vPoints[0];
  // Draw
  cvFillConvexPoly(m_pImage->GetImage(), pPoint, in_iPoints, iColor);
}

