//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlintelimage.h,v 1.7 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifndef __GMLINTELIMAGE_H__
#define __GMLINTELIMAGE_H__

#include "gmlimage.h"

struct _IplImage;

namespace gml
{
  /** @addtogroup Images
   *  @{
   */

  /// Manipulates uncompressed device- and platform-independent bitmaps.

  /// The data is stored sequentially without padding in the bitmap. The class implements exactly
  /// the interface defined by gml::Image without additions.
  class IntelImage : public Image
  {
    public:

      /// Creates an empty bitmap.
      IntelImage();

      /// Destroys the bitmap.
      virtual ~IntelImage();

      /// Copy constructor
      IntelImage(const Image& Orig);

      /// Copy constructor
      IntelImage(const IntelImage& Orig);

      /// Assignment operator
      IntelImage& operator =(const Image& Orig);

      // Assignment operator.
      IntelImage& operator =(const IntelImage& Orig);

      // IntelImage information

      /// Returns the amount of memory used by the object.
      long GetMemUsed();

      /// Returns number of bytes used per line.
      long GetBytesPerLine() const;

      // own interface
      const BYTE* GetRawData() const
      {
        return m_pBits;
      }
      /// Access to raw data array. Dangerous function! Use with care.
      BYTE* GetRawData()
      {
        return m_pBits;
      } 

      /// Access to intel image structure! Use with care.
      struct _IplImage* GetImage()
      {
        return m_pImage;
      } 

      /// Draw surface
      virtual gml::DrawSurface* GetDrawSurface();

      // Static functions


    protected:
      // Local functions

      virtual void ConstructorInitLocals();

      virtual bool InternalCreate(int Width,
                                  int Height,
                                  FORMAT format,
                                  REPRES repres,
                                  ORIENT orient = O_BOTTOMLEFT);

      // Deletes memory allocated by member variables.
      virtual void FreeMembers();

      // Initializes internal table of line addresses.
      virtual void InitLineArray();

      virtual void InternalChangeOrientation(ORIENT new_orient);

      /// Pointer to stored IplImage
      struct _IplImage* m_pImage;
      BYTE* m_pBits;
      int m_iBytesPerLine;
  };

  // Note that _both_ these copy constructors are needed. If only the 
  // second one is there, MSVC generates a default copy 
  // constructor anyway :-(.
  inline IntelImage::IntelImage(const IntelImage& Orig) : Image()
  {
    ConstructorInitLocals();
    InternalCopy(Orig);
  }

  inline IntelImage::IntelImage(const Image& Orig) : Image()
  {
    ConstructorInitLocals();
    InternalCopy(Orig);
  }

  inline IntelImage& IntelImage::operator=(const Image& Orig)
  {
    Image::operator = (Orig);
    return *this;
  }

  inline IntelImage& IntelImage::operator=(const IntelImage& Orig)
  {
    Image::operator = (Orig);
    return *this;
  }

  /** @} */
} // namespace gml


#endif //__GMLINTELIMAGE_H__