//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlimageloader.h,v 1.10 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifndef _GML_BITMAP_LOADER_H_
#define _GML_BITMAP_LOADER_H_

#include <string>

namespace gml
{
  /** @addtogroup Images
   *  @{
   */

  const PRESERVE_JPEG_EXIF = 1;

  class Image;
  /// Loading and saving bitmaps to files (base class)
  class ImageLoader
  {
    public:
      enum IMAGE_FORMAT { FORMAT_BMP,
                          FORMAT_ICO,
                          FORMAT_JPEG,
                          FORMAT_PNG,
                          FORMAT_PGM,
                          FORMAT_PGMRAW,
                          FORMAT_PPM,
                          FORMAT_TIFF,
                          FORMAT_TARGA,
                          FORMAT_UNKNOWN };

      /// @brief Get file extension for particular image file format
      /// @param Image format
      /// @return A string containing required extension
      static std::string GetFormatExtension(IMAGE_FORMAT format);

      virtual bool EnumerateLoadableFormats(void (*f) (IMAGE_FORMAT f)) = 0;
      virtual bool EnumerateSaveableFormats(void (*f) (IMAGE_FORMAT f)) = 0;


      virtual IMAGE_FORMAT CheckBitMapFile(const std::string& path) = 0;

      virtual bool LoadBitMap(const std::string& path,
                              Image& out_bitmap,
                              IMAGE_FORMAT format = FORMAT_UNKNOWN,
                              int flags = 0) = 0;

      virtual bool SaveBitMap(const std::string& path,
                              const Image& bitmap,
                              IMAGE_FORMAT format = FORMAT_UNKNOWN,
                              int in_iQuality = 100,
                              int flags = 0) = 0;
  };
  /** @} */
} // namespace gml

#endif