//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlimageloader.cpp,v 1.4 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#include "../../base/gmlcommon.h"

#include <string>
#include "gmlimageloader.h"

using gml::ImageLoader;

std::string ImageLoader::GetFormatExtension(IMAGE_FORMAT format)
{
  switch (format)
  {
    case FORMAT_BMP:
      return "bmp";
    case FORMAT_ICO:
      return "ico";
    case FORMAT_JPEG:
      return "jpg";
    case FORMAT_PNG:
      return "png";
    case FORMAT_PGM:
      return "pgm";
    case FORMAT_PGMRAW:
      return "pgmraw";
    case FORMAT_PPM:
      return "ppm";
    case FORMAT_TIFF:
      return "tif";
    case FORMAT_TARGA:
      return "tga";
    case FORMAT_UNKNOWN:
    default:
      ASSERT(false); // we don't know such format. GetFormatExtension() should be updated???
      return "";
  }
}