//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlimagefilter.h,v 1.6 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifndef _GMLIMAGEFILTER_H_
#define _GMLIMAGEFILTER_H_

namespace gml
{
  /** @addtogroup Images
   *  @{ 
   */

  /** @addtogroup ImageFilters
   *  @{
   */

  class Image;

  /// Interface for generic image modifier
  class ImageFilter
  {
    public:

      ImageFilter()
      {
      }
      virtual ~ImageFilter()
      {
      };

      /// In-Place Apply. 
      /**Applies the filter to pBmp. The base-class version copies the 
       * bitmap after calling Apply (pBmp, pTempBmp). 
       */
      virtual void ApplyInPlace(Image* pBmp) const;

      /// Applies the Filter to pBmpSource and stores the result in pBmpDest. 
      /**
      The base-class version copies the bitmap before calling ApplyInPlace (pBmpDest). 
      */
      virtual void Apply(const Image* pBmpSource, Image* pBmpDest) const;
  };

  /** @} */

  /** @} */
} // namespace gml

#endif