//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlimagefilter.cpp,v 1.9 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#include "../../base/gmlcommon.h"
#ifdef GML_USE_MFC
#include <afxwin.h>
#endif
#include "gmlimagefilter.h"
#include "gmlimage.h"
#include "gmlsimpleimage.h"
#include "../../base/gmlref.h"

using gml::Image;
using gml::SimpleImage;
using gml::ImageFilter;

void ImageFilter::ApplyInPlace(Image* pBmp) const
{
  // Use a bitmap class that's guaranteed to work on all platforms as
  // temporary storage.
  gml::SimpleImage TempBitmap;
  Apply(pBmp, &TempBitmap);
  *pBmp = TempBitmap;
}

void ImageFilter::Apply(const Image* pBmpSource, Image* pBmpDest) const
{
  *pBmpDest = *pBmpSource;
  ApplyInPlace(pBmpDest);
}
