//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlimagecomposer.h,v 1.5 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifndef _GMLIMAGECOMPOSER_H_
#define _GMLIMAGECOMPOSER_H_

namespace gml
{
  /** @addtogroup ImageFilters
   *  @{
   */

  class Image;
  /// Produce single image from several reference images
  class ImageComposer
  {
    public:

      ImageComposer()
      {
      }
      virtual ~ImageComposer()
      {
      };

      /// Applies the Composer to *(pBmpSource[0]).. *(pBmpSource[n_images - 1])
      /// and stores the result in pBmpDest. 
      virtual void Apply(const std::vector<Image*>& source, Image* pBmpDest) const;
  };

  /// Decompose an image into several destination images
  class ImageDecomposer
  {
    public:

      ImageDecomposer()
      {
      }
      virtual ~ImageDecomposer()
      {
      };

      /// Decompase pBmpSource to several images which are stored in out_dest
      virtual void Apply(Image* pBmpSource, std::vector<Image*>& out_dest) const;
  };


  /** @} */
} // namespace gml

#endif