//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlgdisurface.h,v 1.5 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifndef _GMLGDISURFACE_H_
#define _GMLGDISURFACE_H_

#include "gmldrawsurface.h"

namespace gml
{
  /** @addtogroup Images
   *  @{
   */
  class GDIImage;

  /// Generic image class
  /** Some functionality should be defined in children */
  class GDISurface : public DrawSurface
  {
    public:

      /// Constructor..
      GDISurface(gml::GDIImage* in_pImage);

      /// Empty destructor.
      virtual ~GDISurface();

      // /// @name Image drawing
      void DrawLine(int in_iX0,
                    int in_iY0,
                    int in_iX1,
                    int in_iY1,
                    Color3ub in_Color = Color3ub(255,
                                                 255,
                                                 255));
      void DrawLine(gml::Vector2i in_vStart,
                    gml::Vector2i in_vEnd,
                    Color3ub in_Color = Color3ub(255,
                                                 255,
                                                 255));

      void FrameRect(int in_iX0,
                     int in_iY0,
                     int in_iX1,
                     int in_iY1,
                     Color3ub in_Color = Color3ub(255,
                                                  255,
                                                  255));
      void FrameRect(gml::Vector2i in_vMin,
                     gml::Vector2i in_vMax,
                     Color3ub in_Color = Color3ub(255,
                                                  255,
                                                  255));

      void Circle(int in_iX0,
                  int in_iY0,
                  int in_iRadius,
                  Color3ub in_Color = Color3ub(255,
                                               255,
                                               255));
      void Circle(gml::Vector2i in_vCenter,
                  int in_iRadius,
                  Color3ub in_Color = Color3ub(255,
                                               255,
                                               255));

      void PolyLine(gml::Vector2i* in_pVectors,
                    int in_iPoints,
                    Color3ub in_Color = Color3ub(255,
                                                 255,
                                                 255));

      void PolyGon(gml::Vector2i* in_pVectors,
                   int in_iPoints,
                   Color3ub in_Color = Color3ub(255,
                                                255,
                                                255));
    protected:
      GDIImage* m_pImage;

      DWORD GetColor(gml::Color3ub in_Color);
  };
};
#endif
