//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlgdisurface.cpp,v 1.7 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#include "../../base/gmlcommon.h"
#include "gmlgdiimage.h"
#include "gmlgdisurface.h"
#include <windows.h>

using gml::GDIImage;
using gml::GDISurface;

GDISurface::GDISurface(GDIImage* in_pImage) : m_pImage(in_pImage)
{
  ASSERT(m_pImage);
}


GDISurface::~GDISurface()
{
}

//===================================================================
//= Function name : CreatePen
//= Description   : 
//= Return type   : void  
//===================================================================

DWORD GDISurface::GetColor(gml::Color3ub in_Color)
{
  COLORREF Result = 0;
  // Create pen
  switch (m_pImage->GetFormat())
  {
    case Image::F_BGR:
      Result = RGB(in_Color.r, in_Color.g, in_Color.b);
      break;
    case Image::F_RGB:
      Result = RGB(in_Color.b, in_Color.g, in_Color.r);
      break;
    case Image::F_L:
      Result = RGB(in_Color.r, in_Color.r, in_Color.r);
      break;
  }

  return Result;
}

//===================================================================
//= Function name : DrawLine
//= Description   : 
//= Return type   : void  
//===================================================================

void GDISurface::DrawLine(int in_iX0,
                          int in_iY0,
                          int in_iX1,
                          int in_iY1,
                          gml::Color3ub in_Color)
{
  HPEN hPen, hOldPen;
  COLORREF Color = GetColor(in_Color);

  if (m_pImage->GetOrient() == Image::O_BOTTOMLEFT)
  {
    in_iY0 = m_pImage->GetHeight() - in_iY0;
    in_iY1 = m_pImage->GetHeight() - in_iY1;
  }

  // Create pen
  hPen = CreatePen(PS_SOLID, 0, Color);
  ASSERT(hPen);
  // Select pen
  hOldPen = (HPEN) SelectObject(m_pImage->m_hDC, hPen);

  if (hOldPen)
  {
    // Draw
    MoveToEx(m_pImage->m_hDC, in_iX0, in_iY0, NULL);
    LineTo(m_pImage->m_hDC, in_iX1, in_iY1);

    // Clean up I
    SelectObject(m_pImage->m_hDC, hOldPen);
  }
  // Clean up II
  VERIFY(DeleteObject(hPen));
}


//===================================================================
//= Function name : DrawLine
//= Description   : 
//= Return type   : void  
//===================================================================

void GDISurface::DrawLine(gml::Vector2i in_vStart,
                          gml::Vector2i in_vEnd,
                          gml::Color3ub in_Color)
{
  DrawLine(in_vStart.x, in_vStart.y, in_vEnd.x, in_vEnd.y, in_Color);
}

//===================================================================
//= Function name : FrameRect
//= Description   : 
//= Return type   : void  
//===================================================================

void GDISurface::FrameRect(int in_iX0,
                           int in_iY0,
                           int in_iX1,
                           int in_iY1,
                           gml::Color3ub in_Color)
{
  HBRUSH hBrush;
  COLORREF Color = GetColor(in_Color);
  RECT Rect;

  if (m_pImage->GetOrient() == Image::O_BOTTOMLEFT)
  {
    in_iY1 = m_pImage->GetHeight() - in_iY1;
    in_iY0 = m_pImage->GetHeight() - in_iY0;
    std::swap(in_iY0, in_iY1);
  }

  Rect.left = in_iX0; Rect.top = in_iY0;
  Rect.right = in_iX1; Rect.bottom = in_iY1;

  // Create pen
  hBrush = CreateSolidBrush(Color);
  ASSERT(hBrush);

  if (hBrush)
    // Draw
    ::FrameRect(m_pImage->m_hDC, &Rect, hBrush);

  // Clean up
  VERIFY(DeleteObject(hBrush));
}

//===================================================================
//= Function name : FrameRect
//= Description   : 
//= Return type   : void  
//===================================================================

void GDISurface::FrameRect(gml::Vector2i in_vStart,
                           gml::Vector2i in_vEnd,
                           gml::Color3ub in_Color)
{
  FrameRect(in_vStart.x, in_vStart.y, in_vEnd.x, in_vEnd.y, in_Color);
}

//===================================================================
//= Function name : FrameRect
//= Description   : 
//= Return type   : void  
//===================================================================

void GDISurface::Circle(int in_iX0,
                        int in_iY0,
                        int in_iRadius,
                        gml::Color3ub in_Color)
{
  HPEN hPen, hOldPen;
  COLORREF Color = GetColor(in_Color);

  if (m_pImage->GetOrient() == Image::O_BOTTOMLEFT)
    in_iY0 = m_pImage->GetHeight() - in_iY0;

  // Create pen
  hPen = CreatePen(PS_SOLID, 0, Color);
  ASSERT(hPen);
  // Select pen
  hOldPen = (HPEN) SelectObject(m_pImage->m_hDC, hPen);

  if (hOldPen)
  {
    // Draw
    Arc(m_pImage->m_hDC,
        in_iX0 - in_iRadius,
        in_iY0 - in_iRadius,
        in_iX0 + in_iRadius,
        in_iY0 + in_iRadius,
        in_iX0,
        in_iY0,
        in_iX0,
        in_iY0);

    // Clean up I
    SelectObject(m_pImage->m_hDC, hOldPen);
  }
  // Clean up II
  VERIFY(DeleteObject(hPen));
}

//===================================================================
//= Function name : FrameRect
//= Description   : 
//= Return type   : void  
//===================================================================

void GDISurface::Circle(gml::Vector2i in_vCenter,
                        int in_iRadius,
                        gml::Color3ub in_Color)
{
  Circle(in_vCenter.x, in_vCenter.y, in_iRadius, in_Color);
  //Ellipse
}

//===================================================================
//= Function name : FrameRect
//= Description   : 
//= Return type   : void  
//===================================================================

void GDISurface::PolyLine(gml::Vector2i* in_pVectors,
                          int in_iPoints,
                          gml::Color3ub in_Color)
{
  HPEN hPen, hOldPen;
  std::vector<POINT> vPoints;
  COLORREF Color = GetColor(in_Color);

  // Fill points array
  vPoints.resize(in_iPoints);
  if (m_pImage->GetOrient() == Image::O_BOTTOMLEFT)
  {
    for (int i = 0; i < in_iPoints; i++)
    {
      vPoints[i].x = in_pVectors[i].x;
      vPoints[i].y = m_pImage->GetHeight() - in_pVectors[i].y;
    }
  }
  else
  {
    for (int i = 0; i < in_iPoints; i++)
    {
      //vPoints[i] = in_pVectors[i];
      vPoints[i].x = in_pVectors[i].x;
      vPoints[i].y = in_pVectors[i].y;
    }
  }

  // Create pen
  hPen = (HPEN) CreatePen(PS_SOLID, 0, Color);
  ASSERT(hPen);

  // Select pen
  hOldPen = (HPEN) SelectObject(m_pImage->m_hDC, hPen);

  if (hOldPen)
  {
    // Draw
    Polyline(m_pImage->m_hDC, &vPoints[0], in_iPoints);
    // Clean up I
    SelectObject(m_pImage->m_hDC, hOldPen);
  }
  // Clean up II
  VERIFY(DeleteObject(hPen));
}

//===================================================================
//= Function name : FrameRect
//= Description   : 
//= Return type   : void  
//===================================================================

void GDISurface::PolyGon(gml::Vector2i* in_pVectors,
                         int in_iPoints,
                         gml::Color3ub in_Color)
{
  HPEN hPen, hOldPen;
  std::vector<POINT> vPoints;
  COLORREF Color = GetColor(in_Color);

  // Fill points array
  vPoints.resize(in_iPoints);
  if (m_pImage->GetOrient() == Image::O_BOTTOMLEFT)
  {
    for (int i = 0; i < in_iPoints; i++)
    {
      vPoints[i].x = in_pVectors[i].x;
      vPoints[i].y = m_pImage->GetHeight() - in_pVectors[i].y;
    }
  }
  else
  {
    for (int i = 0; i < in_iPoints; i++)
    {
      //vPoints[i] = in_pVectors[i];
      vPoints[i].x = in_pVectors[i].x;
      vPoints[i].y = in_pVectors[i].y;
    }
  }

  // Create pen
  hPen = (HPEN) CreatePen(PS_SOLID, 0, Color);
  ASSERT(hPen);

  // Select pen
  hOldPen = (HPEN) SelectObject(m_pImage->m_hDC, hPen);

  if (hOldPen)
  {
    // Draw
    Polyline(m_pImage->m_hDC, &vPoints[0], in_iPoints);
    // Clean up I
    SelectObject(m_pImage->m_hDC, hOldPen);
  }
  // Clean up II
  VERIFY(DeleteObject(hPen));
}


