//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmldrawsurface.h,v 1.5 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifndef _GMLDRAWSURFACE_H_
#define _GMLDRAWSURFACE_H_

#include "../../base/gmlcommon.h"
#include "../../base/gmlsmartobject.h"
#include "../../color/gmlcolor.h"
#include "../../math/gmlvector2.h"

namespace gml
{
  class Image;

  /// Generic image class
  /** Some functionality should be defined in children */
  class DrawSurface : public SmartObject
  {
    public:

      /// Constructor..
      DrawSurface();

      /// Empty destructor.
      virtual ~DrawSurface();

      // /// @name Image drawing
      virtual void DrawLine(int in_iX0,
                            int in_iY0,
                            int in_iX1,
                            int in_iY1,
                            Color3ub in_Color = Color3ub(255,
                                                         255,
                                                         255)) = 0;
      virtual void DrawLine(gml::Vector2i in_vStart,
                            gml::Vector2i in_vEnd,
                            Color3ub in_Color = Color3ub(255,
                                                         255,
                                                         255)) = 0;

      virtual void FrameRect(int in_iX0,
                             int in_iY0,
                             int in_iX1,
                             int in_iY1,
                             Color3ub in_Color = Color3ub(255,
                                                          255,
                                                          255)) = 0;
      virtual void FrameRect(gml::Vector2i in_vMin,
                             gml::Vector2i in_vMax,
                             Color3ub in_Color = Color3ub(255,
                                                          255,
                                                          255)) = 0;

      virtual void Circle(int in_iX0,
                          int in_iY0,
                          int in_iRadius,
                          Color3ub in_Color = Color3ub(255,
                                                       255,
                                                       255)) = 0;
      virtual void Circle(gml::Vector2i in_vCenter,
                          int in_iRadius,
                          Color3ub in_Color = Color3ub(255,
                                                       255,
                                                       255)) = 0;

      virtual void PolyLine(gml::Vector2i* in_pVectors,
                            int in_iPoints,
                            Color3ub in_Color = Color3ub(255,
                                                         255,
                                                         255)) = 0;

      virtual void PolyGon(gml::Vector2i* in_pVectors,
                           int in_iPoints,
                           Color3ub in_Color = Color3ub(255,
                                                        255,
                                                        255)) = 0;
  };
};
#endif
