//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlsetrectfilter.h,v 1.4 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifndef __GMLRESETRECTFILTER_H__
#define __GMLRESETRECTFILTER_H__

#include "../gmlimagefilter.h"
#include "../../../math/gmlbbox2.h"

namespace gml
{
  /** @addtogroup ImageFilters
   *  @{
   */

  class Image;
  /// Creates a grayscale version of a color bitmap
  class SetRectFilter : public ImageFilter
  {
    public:
      SetRectFilter(double in_dValue);
      SetRectFilter(double in_dValue,
                    gml::Vector2i in_vMin,
                    gml::Vector2i in_vMax);
      SetRectFilter(double in_dValue,
                    int in_iMinX,
                    int in_iMinY,
                    int in_iMaxX,
                    int in_iMaxY);
      virtual ~SetRectFilter();

      void SetParam(double in_dValue);
      void SetParam(double in_dValue,
                    gml::Vector2i in_vMin,
                    gml::Vector2i in_vMax);
      void SetParam(double in_dValue,
                    int in_iMinX,
                    int in_iMinY,
                    int in_iMaxX,
                    int in_iMaxY);

      virtual void Apply(const Image* pBmpSource, Image* pBmpDest) const;
    private:
      double m_dValue;
      BBox2i m_Box;
  };

  /** @} */
} // namespace gml

#endif //__GMLRESETRECTFILTER_H__