//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlreflectfilter.h,v 1.4 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifndef _GMLREFLECTFILTER_H_
#define _GMLREFLECTFILTER_H_

#include "../gmlimagefilter.h"

namespace gml
{
  /** @addtogroup ImageFilters
   *  @{
   */

  class Image;
  /// Creates a grayscale version of a color bitmap
  class ReflectFilter : public ImageFilter
  {
    public:
      ReflectFilter(bool in_bVert, bool in_bHor);
      virtual ~ReflectFilter();

      virtual void Apply(const Image* pBmpSource, Image* pBmpDest) const;

    private:
      template <class T>
      void ApplyCore(int width,
                     int height,
                     BYTE** pSrcLines,
                     BYTE** pDstLines,
                     int src_elem_size,
                     int dst_elem_size) const;
    private:
      bool m_bVerticalReflect, m_bHorizontalReflect;
  };

  /** @} */
} // namespace gml

#endif