//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlreflectfilter.cpp,v 1.6 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#include "../../../base/gmlcommon.h"
#ifdef GML_USE_MFC
#include <afxwin.h>
#endif
#include "../gmlimage.h"
#include "gmlreflectfilter.h"
#include <vector>
#include <algorithm>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

using gml::ReflectFilter;
using gml::Image;

ReflectFilter::ReflectFilter(bool in_bVert, bool in_bHor) : ImageFilter(),
                                                            m_bVerticalReflect(in_bVert),
                                                            m_bHorizontalReflect(in_bHor)
{
}

ReflectFilter::~ReflectFilter()
{
}

namespace
{
  template <class T>
  class Do
  {
    public:
      void operator()(int width,
                      int height,
                      BYTE** pSrcLines,
                      BYTE** pDstLines,
                      bool in_bVert,
                      bool in_bHor) const
      {
        for (int y = 0; y < height; ++y)
        {
          // For each line
          T* pSrcPixel;
          if (in_bVert)
          {
            pSrcPixel = reinterpret_cast<T*>(pSrcLines[height - y - 1]);
          }
          else
          {
            pSrcPixel = reinterpret_cast<T*>(pSrcLines[y]);
          }
          /*
                  std::vector<BYTE> pSrcPixelInit(pSrcPixel[0], pSrcPixel[width]);
                  if (in_bHor)
                  {
                    std::reverse(pSrcPixelInit.begin(), pSrcPixelInit.end());
                    std::copy(pSrcPixelInit.begin(), pSrcPixelInit.end(), pSrcPixel);
                  }
          */
          T* pDstPixel = reinterpret_cast<T*>(pDstLines[y]);


          //ASSERT(false);
          for (int x = 0; x < width; ++x)
          {
            // For each pixel
            if (!in_bHor)
            {
              pDstPixel[0] = pSrcPixel[0];
              pDstPixel[1] = pSrcPixel[1];
              pDstPixel[2] = pSrcPixel[2];

              pDstPixel += 3;
              pSrcPixel += 3;
            }
            else
            {
              pDstPixel[0] = pSrcPixel[(width - x - 1) * 3];
              pDstPixel[1] = pSrcPixel[(width - x - 1) * 3 + 1];
              pDstPixel[2] = pSrcPixel[(width - x - 1) * 3 + 2];

              pDstPixel += 3;
            }
          }
        }
      }
  };
}

void ReflectFilter::Apply(const Image* pBmpSource, Image* pBmpDest) const
{
  ASSERT(pBmpSource->GetFormat() == Image::F_RGB ||
         pBmpSource->GetFormat() == Image::F_BGR);

  pBmpDest->Create(pBmpSource->GetWidth(),
                   pBmpSource->GetHeight(),
                   pBmpSource->GetFormat(),
                   pBmpSource->GetRepres(),
                   pBmpSource->GetOrient());
  BYTE** pSrcLines = pBmpSource->GetLineArray();
  BYTE** pDstLines = pBmpDest->GetLineArray();

  int iHeight = pBmpSource->GetHeight();
  int iWidth = pBmpSource->GetWidth();

  switch (pBmpSource->GetRepres())
  {
    case Image::R_BYTE:
      Do<BYTE>()(pBmpDest->GetWidth(),
                 pBmpDest->GetHeight(),
                 pSrcLines,
                 pDstLines,
                 m_bVerticalReflect,
                 m_bHorizontalReflect); 
      break;
    case Image::R_WORD:
      Do<WORD>()(pBmpDest->GetWidth(),
                 pBmpDest->GetHeight(),
                 pSrcLines,
                 pDstLines,
                 m_bVerticalReflect,
                 m_bHorizontalReflect); 
      break;
    case Image::R_FLOAT:
      Do<float>()(pBmpDest->GetWidth(),
                  pBmpDest->GetHeight(),
                  pSrcLines,
                  pDstLines,
                  m_bVerticalReflect,
                  m_bHorizontalReflect); 
      break;
  };
}



