//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlfilterrgb2rgba.h,v 1.4 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifndef _GMLFILTERRGB2RGBA_H_
#define _GMLFILTERRGB2RGBA_H_

#include "../gmlimagefilter.h"
#include "../../../color/gmlcolor.h"

namespace gml
{
  /** @addtogroup ImageFilters
   *  @{
   */

  class Image;
  /// Creates a grayscale version of a color bitmap
  class FilterRGB2RGBA : public ImageFilter
  {
    public:
      FilterRGB2RGBA(const gml::Color3ub& in_Color = gml::Color3ub(255,
                                                                   255,
                                                                   255));
      virtual ~FilterRGB2RGBA();

      virtual void Apply(const Image* pBmpSource, Image* pBmpDest) const;

      void SetTransparentColor(const gml::Color3ub& in_Color);

    private:
      template <class T>
      void ApplyCore(int width,
                     int height,
                     BYTE** pSrcLines,
                     BYTE** pDstLines,
                     int src_elem_size,
                     int dst_elem_size) const;

      Color3ub m_TransparentColor;
  };

  /** @} */
} // namespace gml

#endif