//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlfilterrgb2rgba.cpp,v 1.6 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#include "../../../base/gmlcommon.h"
#ifdef GML_USE_MFC
#include <afxwin.h>
#endif
#include "../gmlimage.h"
#include "gmlFilterRGB2RGBA.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

using namespace gml;

FilterRGB2RGBA::FilterRGB2RGBA(const gml::Color3ub& in_Color) : ImageFilter()
{
  SetTransparentColor(in_Color);
}

FilterRGB2RGBA::~FilterRGB2RGBA()
{
}

namespace
{
  template <class T>
  class Do
  {
    public:
      void operator()(int width,
                      int height,
                      BYTE** pSrcLines,
                      BYTE** pDstLines,
                      const Color3ub& TransparentColor) const
      {
        for (int y = 0; y < height; ++y)
        {
          // For each line
          T* pSrcPixel = reinterpret_cast<T*>(pSrcLines[y]);
          T* pDstPixel = reinterpret_cast<T*>(pDstLines[y]);

          //ASSERT(false);
          for (int x = 0; x < width ; ++x)
          {
            // For each pixel

            pDstPixel[0] = pSrcPixel[0];
            pDstPixel[1] = pSrcPixel[1];
            pDstPixel[2] = pSrcPixel[2];

            if (pSrcPixel[0] == TransparentColor[0] &&
                pSrcPixel[1] == TransparentColor[1] &&
                pSrcPixel[2] == TransparentColor[2])
            {
              pDstPixel[3] = 0;
            }
            else
            {
              pDstPixel[3] = 255;
            }

            pSrcPixel += 3; // SOURCE IS RGB
            pDstPixel += 4; // DEST IS RGBA        
          };
        };
      };
  };
};


void FilterRGB2RGBA::Apply(const Image* pBmpSource, Image* pBmpDest) const
{
  ASSERT(pBmpSource->GetFormat() == Image::F_RGB);

  pBmpDest->Create(pBmpSource->GetWidth(),
                   pBmpSource->GetHeight(),
                   Image::F_RGBA,
                   pBmpSource->GetRepres(),
                   pBmpSource->GetOrient());
  BYTE** pSrcLines = pBmpSource->GetLineArray();
  BYTE** pDstLines = pBmpDest->GetLineArray();

  switch (pBmpSource->GetRepres())
  {
    case Image::R_BYTE:
      Do<BYTE>()(pBmpDest->GetWidth(),
                 pBmpDest->GetHeight(),
                 pSrcLines,
                 pDstLines,
                 m_TransparentColor); break;
    case Image::R_WORD:
      Do<WORD>()(pBmpDest->GetWidth(),
                 pBmpDest->GetHeight(),
                 pSrcLines,
                 pDstLines,
                 m_TransparentColor); break;
    case Image::R_FLOAT:
      Do<float>()(pBmpDest->GetWidth(),
                  pBmpDest->GetHeight(),
                  pSrcLines,
                  pDstLines,
                  m_TransparentColor); break;
    case Image::R_DOUBLE:
      Do<double>()(pBmpDest->GetWidth(),
                   pBmpDest->GetHeight(),
                   pSrcLines,
                   pDstLines,
                   m_TransparentColor); break;
  };
}

void FilterRGB2RGBA::SetTransparentColor(const gml::Color3ub& in_Color)
{
  m_TransparentColor = in_Color;
}
