//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlfilterrgb2bgr.h,v 1.6 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifndef __GMLFILTERRGB2BGR_H__
#define __GMLFILTERRGB2BGR_H__

#include "../gmlimagefilter.h"

namespace gml
{
  /** @addtogroup ImageFilters
   *  @{
   */

  class Image;
  /// Creates a Lum2RGB version of a color bitmap
  class FilterRGB2BGR : public ImageFilter
  {
    public:
      FilterRGB2BGR();
      virtual ~FilterRGB2BGR();

      virtual void ApplyInPlace(Image* pBmp) const;

    private:
      void ApplyCore(int width,
                     int height,
                     BYTE** pSrcLines,
                     BYTE** pDstLines,
                     int src_elem_size,
                     int dst_elem_size) const;
  };

  /** @} */
} // namespace gml

#endif //__GMLFILTERRGB2BGR_H__