//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlfilterresize.h,v 1.8 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifndef _GMLFILTERRESIZE_H_
#define _GMLFILTERRESIZE_H_

#include "../gmlimagefilter.h"

namespace gml
{
  /** @addtogroup ImageFilters
   *  @{
   */

  class Image;
  /// Creates a MedianBlur version of a color bitmap
  class FilterResize : public ImageFilter
  {
    public:
      enum RESIZE_TYPE { FASTEST = 1, BILINEAR };

      FilterResize();
      FilterResize(int in_iDstWdt, int in_iDstHgt, RESIZE_TYPE in_Type);
      virtual ~FilterResize();

      virtual void Apply(const Image* pBmpSource, Image* pBmpDest) const;
      virtual void SetResizeParam(int in_iDstWdt,
                                  int in_iDstHgt,
                                  RESIZE_TYPE in_Type)
      {
        m_ResizeType = in_Type;
        m_iDstWdt = in_iDstWdt;
        m_iDstHgt = in_iDstHgt;

        ASSERT(m_iDstWdt > 0);
        ASSERT(m_iDstHgt > 0);
      };

    private:
      RESIZE_TYPE m_ResizeType;
      int m_iDstWdt, m_iDstHgt;
  };

  /** @} */
} // namespace gml

#endif