//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlfilterrepres.h,v 1.4 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifndef _GMLFILTERREPRES_H_
#define _GMLFILTERREPRES_H_

#include "../gmlimagefilter.h"

namespace gml
{
  /** @addtogroup ImageFilters
   *  @{
   */

  class Image;
  /// Transferres between different representations
  class FilterRepres : public ImageFilter
  {
    public:
      FilterRepres(Image::REPRES in_Repres = Image::R_BYTE,
                   double in_dCoeff = 1,
                   bool in_bClipTypeBounds = true);
      virtual ~FilterRepres();

      void SetParam(Image::REPRES in_Repres = Image::R_BYTE,
                    double in_dCoeff = 1,
                    bool in_bClipTypeBounds = true);

      virtual void Apply(const Image* pBmpSource, Image* pBmpDest) const;
    private:
      //template <class T> void UglySort(T **in_pSrcLines, Image * pBmpDest);
      double m_dCoeff;
      bool m_bClipTypeBounds;
      Image::REPRES m_DestRepres;
  };

  /** @} */
} // namespace gml

#endif