//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlfiltermedian.h,v 1.4 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifndef _GMLFILTERLUM2MedianBlur_H_
#define _GMLFILTERLUM2MedianBlur_H_

#include "../gmlimagefilter.h"

namespace gml
{
  /** @addtogroup ImageFilters
   *  @{
   */

  class Image;
  /// Creates a MedianBlur version of a color bitmap
  class FilterMedianBlur : public ImageFilter
  {
    public:
      FilterMedianBlur();
      virtual ~FilterMedianBlur();

      virtual void Apply(const Image* pBmpSource, Image* pBmpDest) const;
      virtual void SetRadius(int r)
      {
        ASSERT(r > 0); m_r = r;
      }

    private:
      template <class T>
      void ApplyCore(int width,
                     int height,
                     BYTE** pSrcLines,
                     BYTE** pDstLines,
                     int src_elem_size,
                     int dst_elem_size) const;

      int m_r;
  };

  /** @} */
} // namespace gml

#endif