//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlfiltermedian.cpp,v 1.7 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#include "../../../base/gmlcommon.h"
#ifdef GML_USE_MFC
#include <afxwin.h>
#endif
#include "../gmlimage.h"
#include "gmlfiltermedian.h"
#include "../../../math/gmlvector3.h"
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

using gml::FilterMedianBlur;
using gml::Image;

FilterMedianBlur::FilterMedianBlur() : ImageFilter()
{
  m_r = 2;
}

FilterMedianBlur::~FilterMedianBlur()
{
}

namespace
{
  template <class T>
  class Do
  {
    public:
      void operator()(int width,
                      int height,
                      BYTE** pSrcLines,
                      BYTE** pDstLines,
                      int src_line_size,
                      int dst_line_size,
                      int src_elem_size,
                      int dst_elem_size,
                      int r) const
      {
        for (int y = r; y < height - r; ++y)
        {
          // For each line
          //T* pSrcPixel = reinterpret_cast<T*>(pSrcLines[y]);
          T* pDstPixel = reinterpret_cast<T*>(pDstLines[y]);

          for (int x = r; x < width - r; ++x)
          {
            // For each pixel

            // for block
            gml::Vector3f med(0, 0, 0);
            for (int y1 = y - r; y1 <= y + r; ++y1)
            {
              T* pSrcPixel = reinterpret_cast<T*>(pSrcLines[y1]) + x * 3;
              for (int x1 = x - r; x1 <= x + r; ++x1)
              {
                med[0] += pSrcPixel[0];
                med[1] += pSrcPixel[1];
                med[2] += pSrcPixel[2];
                pSrcPixel += src_elem_size;
              }
            }
            med /= r * r;

            pDstPixel[0] = med[0];
            pDstPixel[1] = med[1];
            pDstPixel[2] = med[2];

            gml::Vector3f& r = gml::Vector3f::Cast((float*) pDstPixel);
            r.Normalize();
            pDstPixel += 3;
          }
        }
      }
  };
}

void FilterMedianBlur::Apply(const Image* pBmpSource, Image* pBmpDest) const
{
  ASSERT(pBmpSource->GetFormat() == Image::F_RGB);

  pBmpDest->Create(pBmpSource->GetWidth(),
                   pBmpSource->GetHeight(),
                   Image::F_RGB,
                   pBmpSource->GetRepres(),
                   pBmpSource->GetOrient());

  BYTE** pSrcLines = pBmpSource->GetLineArray();
  BYTE** pDstLines = pBmpDest->GetLineArray();
  int src_elem_size = pBmpSource->GetElemSize();
  int dst_elem_size = pBmpDest->GetElemSize();

  switch (pBmpSource->GetRepres())
  {
    case Image::R_BYTE:
      Do<BYTE>()(pBmpDest->GetWidth(),
                 pBmpDest->GetHeight(),
                 pSrcLines,
                 pDstLines,
                 pBmpSource->GetBytesPerLine(),
                 pBmpDest->GetBytesPerLine(),
                 src_elem_size,
                 dst_elem_size,
                 m_r); break;
    case Image::R_WORD:
      Do<WORD>()(pBmpDest->GetWidth(),
                 pBmpDest->GetHeight(),
                 pSrcLines,
                 pDstLines,
                 pBmpSource->GetBytesPerLine(),
                 pBmpDest->GetBytesPerLine(),
                 src_elem_size,
                 dst_elem_size,
                 m_r); break;
    case Image::R_FLOAT:
      Do<float>()(pBmpDest->GetWidth(),
                  pBmpDest->GetHeight(),
                  pSrcLines,
                  pDstLines,
                  pBmpSource->GetBytesPerLine(),
                  pBmpDest->GetBytesPerLine(),
                  src_elem_size,
                  dst_elem_size,
                  m_r); break;
    case Image::R_DOUBLE:
      Do<double>()(pBmpDest->GetWidth(),
                   pBmpDest->GetHeight(),
                   pSrcLines,
                   pDstLines,
                   pBmpSource->GetBytesPerLine(),
                   pBmpDest->GetBytesPerLine(),
                   src_elem_size,
                   dst_elem_size,
                   m_r); break;
  };
}


