//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlfilterlumrgb2bgr.cpp,v 1.7 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#include "../../../base/gmlcommon.h"
#ifdef GML_USE_MFC
#include <afxwin.h>
#endif
#include "../gmlimage.h"
#include "gmlfilterrgb2bgr.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

using gml::FilterRGB2BGR;
using gml::Image;

FilterRGB2BGR::FilterRGB2BGR() : ImageFilter()
{
}

FilterRGB2BGR::~FilterRGB2BGR()
{
}

namespace
{
  template <class T>
  class Do
  {
    public:
      void operator()(int width,
                      int height,
                      BYTE** pSrcLines,
                      int src_elem_size) const
      {
        for (int y = 0; y < height; ++y)
        {
          // For each line
          T* pSrcPixel = reinterpret_cast<T*>(pSrcLines[y]);

          for (int x = 0; x < width ; ++x)
          {
            // For each pixel
            T tmp = pSrcPixel[0];
            pSrcPixel[0] = pSrcPixel[2];
            pSrcPixel[2] = tmp;

            pSrcPixel += src_elem_size;
          }
        }
      }
  };
}

void FilterRGB2BGR::ApplyInPlace(Image* pBmp) const
{
  ASSERT(pBmp->GetFormat() == Image::F_RGB ||
         pBmp->GetFormat() == Image::F_BGR);

  BYTE** pSrcLines = pBmp->GetLineArray();
  int src_elem_size = pBmp->GetElemSize();

  switch (pBmp->GetRepres())
  {
    case Image::R_BYTE:
      Do<BYTE>()(pBmp->GetWidth(), pBmp->GetHeight(), pSrcLines, src_elem_size); break;
    case Image::R_WORD:
      Do<WORD>()(pBmp->GetWidth(), pBmp->GetHeight(), pSrcLines, src_elem_size); break;
    case Image::R_FLOAT:
      Do<float>()(pBmp->GetWidth(),
                  pBmp->GetHeight(),
                  pSrcLines,
                  src_elem_size); break;
    case Image::R_DOUBLE:
      Do<double>()(pBmp->GetWidth(),
                   pBmp->GetHeight(),
                   pSrcLines,
                   src_elem_size); break;
  };
}


