//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlfilterlum2rgb.cpp,v 1.8 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#include "../../../base/gmlcommon.h"
#ifdef GML_USE_MFC
#include <afxwin.h>
#endif
#include "../gmlimage.h"
#include "gmlfilterlum2RGB.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

using gml::FilterLum2RGB;
using gml::Image;

FilterLum2RGB::FilterLum2RGB() : ImageFilter()
{
}

FilterLum2RGB::~FilterLum2RGB()
{
}

namespace
{
  template <class T>
  class Do
  {
    public:
      void operator()(int width,
                      int height,
                      BYTE** pSrcLines,
                      BYTE** pDstLines,
                      int src_elem_size,
                      int dst_elem_size) const
      {
        for (int y = 0; y < height; ++y)
        {
          // For each line
          T* pSrcPixel = reinterpret_cast<T*>(pSrcLines[y]);
          T* pDstPixel = reinterpret_cast<T*>(pDstLines[y]);

          //ASSERT(false);
          for (int x = 0; x < width ; ++x)
          {
            // For each pixel

            pDstPixel[0] = pDstPixel[1] = pDstPixel[2] = *pSrcPixel;

            pSrcPixel += src_elem_size;
            pDstPixel += dst_elem_size;
          }
        }
      }
  };
}

void FilterLum2RGB::Apply(const Image* pBmpSource, Image* pBmpDest) const
{
  ASSERT(pBmpSource->GetFormat() == Image::F_L);

  pBmpDest->Create(pBmpSource->GetWidth(),
                   pBmpSource->GetHeight(),
                   Image::F_RGB,
                   pBmpSource->GetRepres(),
                   pBmpSource->GetOrient());

  BYTE** pSrcLines = pBmpSource->GetLineArray();
  BYTE** pDstLines = pBmpDest->GetLineArray();
  int src_elem_size = pBmpSource->GetElemSize();
  int dst_elem_size = pBmpDest->GetElemSize();

  switch (pBmpSource->GetRepres())
  {
    case Image::R_BYTE:
      Do<BYTE>()(pBmpDest->GetWidth(),
                 pBmpDest->GetHeight(),
                 pSrcLines,
                 pDstLines,
                 src_elem_size,
                 dst_elem_size); break;
    case Image::R_WORD:
      Do<WORD>()(pBmpDest->GetWidth(),
                 pBmpDest->GetHeight(),
                 pSrcLines,
                 pDstLines,
                 src_elem_size,
                 dst_elem_size); break;
    case Image::R_FLOAT:
      Do<float>()(pBmpDest->GetWidth(),
                  pBmpDest->GetHeight(),
                  pSrcLines,
                  pDstLines,
                  src_elem_size,
                  dst_elem_size); break;
    case Image::R_DOUBLE:
      Do<double>()(pBmpDest->GetWidth(),
                   pBmpDest->GetHeight(),
                   pSrcLines,
                   pDstLines,
                   src_elem_size,
                   dst_elem_size); break;
  };
}


