//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlfiltergrayscale.h,v 1.7 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifndef _GMLFILTERGRAYSCALE_H_
#define _GMLFILTERGRAYSCALE_H_

#include "../gmlimagefilter.h"

namespace gml
{
  /** @addtogroup ImageFilters
   *  @{
   */

  class Image;
  /// Creates a grayscale version of a color bitmap
  class FilterGrayscale : public ImageFilter
  {
    public:
      FilterGrayscale();
      virtual ~FilterGrayscale();

      virtual void Apply(const Image* pBmpSource, Image* pBmpDest) const;

      /// method to convert from RGB to LUM: take RED, GREEN, BLUE, or simple average color, or use "human eye" formula
      enum METHOD { M_R, M_G, M_B, M_AVERAGE, M_EYE };

      void SetMethod(METHOD m)
      {
        m_method = m;
      }

    private:
      template <class T>
      void ApplyCore(int width,
                     int height,
                     BYTE** pSrcLines,
                     BYTE** pDstLines,
                     int src_elem_size,
                     int dst_elem_size) const;
    private:
      METHOD m_method;
  };

  /** @} */
} // namespace gml

#endif