//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: IPLnDIB.cpp,v 1.4 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

//---------------------------------------------------------------------------

#include "IPLnDIB.h"

//---------------------------------------------------------------------------
// CALCULATE SCAN LINE LENGTH ACCORDING TO ALIGNMENT
//---------------------------------------------------------------------------
int GetScanLineLength(int nCX, int nBPP, int nAlignment)
{
  nAlignment--;
  int nRes = ((nCX* nBPP / 8) + nAlignment) & ~nAlignment;
  return nRes;
}
//---------------------------------------------------------------------------
// ALLOCATE DIB MEMORY OF SPECIFIED PARAMETERS
//---------------------------------------------------------------------------
LPBITMAPINFO AllocateDIBMemory(int nCX, int nCY, int nBPP, LPVOID* ppData)
{
  // Memory size for required parameters
  // ... raster size
  LONG lRasterSize = GetScanLineLength(nCX, nBPP, sizeof(DWORD)) * nCY;
  // ... palette size
  LONG lPaletteSize = (nBPP <= 8) ? sizeof(RGBQUAD) * (1 << nBPP) : 0;
  // Allocation
  LPBITMAPINFO pbiMem = LPBITMAPINFO(iplMalloc(sizeof(BITMAPINFO) +
                                               lRasterSize +
                                               lPaletteSize));
  pbiMem->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
  pbiMem->bmiHeader.biWidth = nCX;
  pbiMem->bmiHeader.biHeight = nCY;
  pbiMem->bmiHeader.biPlanes = 1;
  pbiMem->bmiHeader.biBitCount = nBPP;
  pbiMem->bmiHeader.biCompression = BI_RGB;
  pbiMem->bmiHeader.biClrUsed = 0;
  pbiMem->bmiHeader.biClrImportant = 0;
  // Return raster pointer
  *ppData = LPBYTE(pbiMem) + sizeof(BITMAPINFO) + lPaletteSize;
  return pbiMem;
}
//---------------------------------------------------------------------------
// TRANSLATE DIB INTO IPL
//---------------------------------------------------------------------------
IplImage* DIB2IPL(HBITMAP hDIB)
{
  // Determine DIB parameters
  BITMAPINFO biAux;
  biAux.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
  biAux.bmiHeader.biBitCount = 0;
  HDC hDC = ::GetWindowDC(NULL);
  ::GetDIBits(hDC, hDIB, 100, 0, NULL, &biAux, DIB_RGB_COLORS);
  // Allocate memory for DIB
  LPVOID pRaster;
  LPBITMAPINFO pbiHeader = AllocateDIBMemory(biAux.bmiHeader.biWidth,
                                             biAux.bmiHeader.biHeight,
                                             biAux.bmiHeader.biBitCount,
                                             &pRaster);
  // Convert HBITMAP into just prepared memory as DIB
  ::memcpy(pbiHeader, &biAux, sizeof(BITMAPINFOHEADER));
  int nRes = ::GetDIBits(hDC,
                         hDIB,
                         0,
                         pbiHeader->bmiHeader.biHeight,
                         pRaster,
                         pbiHeader,
                         DIB_RGB_COLORS);
  ::ReleaseDC(NULL, hDC);
  // Translating DIB into IPL of the same format
  // ... create IPL header of 8 bpp or 24 bpp format
  IplImage* pRes;
  if (biAux.bmiHeader.biBitCount > 8)
    pRes = iplCreateImageHeader(3,
                                0,
                                IPL_DEPTH_8U,
                                "RGB",
                                "BGR",
                                IPL_DATA_ORDER_PIXEL,
                                IPL_ORIGIN_TL,
                                IPL_ALIGN_QWORD,
                                pbiHeader->bmiHeader.biWidth,
                                pbiHeader->bmiHeader.biHeight,
                                NULL,
                                NULL,
                                NULL,
                                NULL);
  else
    pRes = iplCreateImageHeader(1,
                                0,
                                IPL_DEPTH_8U,
                                "RGB",
                                "BGR",
                                IPL_DATA_ORDER_PIXEL,
                                IPL_ORIGIN_TL,
                                IPL_ALIGN_QWORD,
                                pbiHeader->bmiHeader.biWidth,
                                pbiHeader->bmiHeader.biHeight,
                                NULL,
                                NULL,
                                NULL,
                                NULL);
  iplConvertFromDIBSep(&(pbiHeader->bmiHeader), (const char *) pRaster, pRes);
  // Deallocate DIB memory
  iplFree(pbiHeader);
  return pRes;
}
//---------------------------------------------------------------------------
// TRANSLATE IPL2DIB
//---------------------------------------------------------------------------
HBITMAP IPL2DIB(IplImage* piiImg)
{
  // DIB memory allocation
  int nBPP = piiImg->depth* piiImg->nChannels;
  LPVOID pAuxRaster;
  LPBITMAPINFO pbiDIB = AllocateDIBMemory(piiImg->width,
                                          piiImg->height,
                                          nBPP,
                                          &pAuxRaster);
  // Convert IPL to DIB
  iplConvertToDIBSep(piiImg,
                     &(pbiDIB->bmiHeader),
                     (char *) pAuxRaster,
                     IPL_DITHER_FS,
                     IPL_PALCONV_MEDCUT);
  // Translate structured DIB into HANDLEd one
  LPVOID pRaster;
  HDC hDC = ::GetWindowDC(NULL);
  HBITMAP hRes = ::CreateDIBSection(hDC,
                                    pbiDIB,
                                    DIB_RGB_COLORS,
                                    &pRaster,
                                    NULL,
                                    NULL);
  ::ReleaseDC(NULL, hDC);
  // Copy structured raster info HANDLEd one
  long lRasterLength = GetScanLineLength(piiImg->width, nBPP, sizeof(DWORD)) * piiImg->height;
  memcpy(pRaster, pAuxRaster, lRasterLength);
  iplFree(pbiDIB);
  return hRes;
}
