//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlfrimageloader.h,v 1.5 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifndef _GMLFRIMAGELOADER_H_
#define _GMLFRIMAGELOADER_H_

// internal headers
#include "../bitmap/gmlimageloader.h"

// forward definitions
enum FREE_IMAGE_FORMAT;

namespace gml
{
  /** @addtogroup Images
   *  @{
   */

  /// Image loader based on FreeImage third-party library
  class FRImageLoader : public ImageLoader
  {
    public:

      virtual bool EnumerateLoadableFormats(void (*f) (IMAGE_FORMAT f));
      virtual bool EnumerateSaveableFormats(void (*f) (IMAGE_FORMAT f));

      virtual IMAGE_FORMAT CheckBitMapFile(const std::string& path);

      virtual bool LoadBitMap(const std::string& path,
                              Image& out_bitmap,
                              IMAGE_FORMAT format = FORMAT_UNKNOWN,
                              int flags = 0);

      virtual bool SaveBitMap(const std::string& path,
                              const Image& bitmap,
                              IMAGE_FORMAT format,
                              int flags = 0);

    private:
      IMAGE_FORMAT MapFreeImageFormatToOwnFormat(FREE_IMAGE_FORMAT f);
      FREE_IMAGE_FORMAT MapOwnFormatToFreeImageFormat(IMAGE_FORMAT f);
  };

  /** @} */
} // namespace gml


#endif