//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlfilefinder.h,v 1.4 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifndef _GMLFILEFINDER_H_
#define _GMLFILEFINDER_H_

#include <vector>

#include "gmlpathstring.h"

namespace gml
{
  /** @addtogroup Files
   *  @{
   */

  /// A class which enumerate all the files and directories under specified
  /// start directory
  /// @todo: add directory structure handling
  class FileFinder
  {
    public:
      FileFinder();
      virtual ~FileFinder();

      /// search the startdir for files with a specified filename or extension filter.
      /// startdir == NULL => from the current directory
      /// recursion level == -1 => all sub-levels
      bool FindFiles(const char* filefilter = "*",
                     const gml::PathString& = "",
                     int recursionlevel = -1);

      gml::PathString GetStartDir();
      // after the 'find' we can retrieve lists of files and directories

      /*
      std::vector<std::PathString>* GetDirListInDir(const gml::PathString& fulldirpath);
      std::vector<std::PathString>* GetFileListInDir(const gml::PathString& fulldirpath);
      bool SearchFileInList(const gml::PathString& fullfilepath);*/
      std::vector<gml::PathString>& GetCompleteFileList();



    protected:
      FileFinder(const FileFinder& right);
      const FileFinder& operator=(const FileFinder& right);

    private:

      void FileFinder::IterateDirToFillInStructure(const gml::PathString& cur_path,
                                                   int reclev);

    private:
      gml::PathString m_startdir; //< directory from which we begin search
      std::string m_filefilter; //< used file filter (like '*', "*.dll")

      std::vector<gml::PathString> m_complete_file_list;
  };


  /** @} */
}
#endif  
