//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlfilefinder.cpp,v 1.6 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#include "../base/gmlcommon.h"
#include "gmlfilefinder.h"

#include <windows.h>

using gml::FileFinder;

// forward declarations for static functions

namespace
{
  HANDLE OwnFindFirstDirectory(LPCTSTR lpszSearchFile, LPWIN32_FIND_DATA lpffd);
  BOOL OwnFindNextDirectory(HANDLE hSearch, LPWIN32_FIND_DATA lpffd);
  HANDLE OwnFindFirstFile(LPCTSTR lpszSearchFile, LPWIN32_FIND_DATA lpffd);
  BOOL OwnFindNextFile(HANDLE hSearch, LPWIN32_FIND_DATA lpffd);
}

FileFinder::FileFinder()
{
}

FileFinder::~FileFinder()
{
}

bool FileFinder::FindFiles(const char* filefilter /*= "*"*/,
                           const gml::PathString& /*= ""*/ path,
                           int recursionlevel /*= -1*/)
{
  m_filefilter = filefilter;

  if (path.empty())
    m_startdir.CurDir();
  else
    m_startdir = path;


  IterateDirToFillInStructure(m_startdir, recursionlevel);

  return true;
}

gml::PathString FileFinder::GetStartDir()
{
  return m_startdir;
}

std::vector<gml::PathString>& FileFinder::GetCompleteFileList()
{
  return m_complete_file_list;
}


void FileFinder::IterateDirToFillInStructure(const gml::PathString& cur_path,
                                             int reclev)
{
  DWORD error = 0;
  WIN32_FIND_DATA w32FindBuf;
  LPWIN32_FIND_DATA lpffd = &w32FindBuf;

  if (reclev == 0)
  {
    return;
  }

  gml::PathString save_cur_path;
  save_cur_path.CurDir();

  bool res = cur_path.ChDir();
  if (res == false) // no such directory
  {
    return;
  }

  // first find all the files and put them in the List.
  HANDLE hFind = OwnFindFirstFile(m_filefilter.c_str(), lpffd);
  if (hFind != INVALID_HANDLE_VALUE)
  {
    gml::PathString file(cur_path, lpffd->cFileName);
    m_complete_file_list.push_back(file);
    while (OwnFindNextFile(hFind, lpffd))
    {
      gml::PathString file(cur_path, lpffd->cFileName);
      m_complete_file_list.push_back(file);
    }
    FindClose(hFind);
  }

  std::vector<gml::PathString> dirs;
  // investigate the directories
  hFind = OwnFindFirstDirectory("*", lpffd);
  if (hFind != INVALID_HANDLE_VALUE)
  {
    dirs.push_back(lpffd->cFileName);
    while (OwnFindNextDirectory(hFind, lpffd))
    {
      dirs.push_back(lpffd->cFileName);
    }
    FindClose(hFind);
  }

  save_cur_path.ChDir();
  for (unsigned int teller = 0; teller < dirs.size(); teller++)
  {
    gml::PathString subdir(cur_path, dirs[teller]);
    IterateDirToFillInStructure(subdir, reclev - 1);
  }
}
// STATIC FUNCTIONS

namespace
{
  HANDLE OwnFindFirstDirectory(LPCTSTR lpszSearchFile, LPWIN32_FIND_DATA lpffd)
  {
    BOOL bRC;
    DWORD dwRC;
    HANDLE hSearch;
    int iRC;

    hSearch = ::FindFirstFile(lpszSearchFile, lpffd);
    if (hSearch == INVALID_HANDLE_VALUE)
      return (hSearch);
    for (; ;)
    {
      dwRC = ::GetFileAttributes(lpffd->cFileName);
      if (dwRC & FILE_ATTRIBUTE_DIRECTORY)
      {
        iRC = strcmp(lpffd->cFileName, ".");
        if (iRC)
        {
          iRC = strcmp(lpffd->cFileName, "..");
          if (iRC)
            return (hSearch);
        }
      }
      bRC = ::FindNextFile(hSearch, lpffd);
      if (bRC == FALSE)
      {
        FindClose(hSearch);
        return INVALID_HANDLE_VALUE;
      }
    }
  }

  HANDLE OwnFindFirstFile(LPCTSTR lpszSearchFile, LPWIN32_FIND_DATA lpffd)
  {
    BOOL bRC;
    DWORD dwRC;
    HANDLE hSearch;

    hSearch = ::FindFirstFile(lpszSearchFile, lpffd);
    if (hSearch == INVALID_HANDLE_VALUE)
      return (hSearch);
    for (; ;)
    {
      dwRC = ::GetFileAttributes(lpffd->cFileName);
      if ((dwRC & FILE_ATTRIBUTE_DIRECTORY) != FILE_ATTRIBUTE_DIRECTORY) // it is not a directory
      {
        return (hSearch);
      }
      bRC = ::FindNextFile(hSearch, lpffd);
      if (bRC == FALSE)
      {
        FindClose(hSearch);
        return (INVALID_HANDLE_VALUE);
      }
    }
  }

  BOOL OwnFindNextDirectory(HANDLE hSearch, LPWIN32_FIND_DATA lpffd)
  {
    BOOL bRC;
    DWORD dwRC;

    for (; ;)
    {
      bRC = ::FindNextFile(hSearch, lpffd);
      if (bRC == FALSE)
        return (FALSE);
      dwRC = ::GetFileAttributes(lpffd->cFileName);
      if (dwRC & FILE_ATTRIBUTE_DIRECTORY)
        return (TRUE);
    }
  }

  BOOL OwnFindNextFile(HANDLE hSearch, LPWIN32_FIND_DATA lpffd)
  {
    BOOL bRC;
    DWORD dwRC;

    for (; ;)
    {
      bRC = ::FindNextFile(hSearch, lpffd);
      if (bRC == FALSE)
        return (FALSE);
      dwRC = ::GetFileAttributes(lpffd->cFileName);
      if ((dwRC & FILE_ATTRIBUTE_DIRECTORY) != FILE_ATTRIBUTE_DIRECTORY)
      {
        return (TRUE);
      }
    }
  }
}


