/** 

@mainpage


\section intro Introduction

Graphics & Media Lab Common Source Library is a C++ library that contains a
set of classes frequently used in graphics research and development.

\section gen_descr General description

The library contains several packages, separated by particular
functionality. The following sections describe them.

\subsection base Base

This package contains the most general classes and utilities:

- definitions like ASSERT(), VERIFY() and NULL
- gml::String type definition (derived from std::string)
- smart pointer facility (gml::Ref, gml::SmartObject
- object-orienter callback facility (gml::Callback)

\subsection math Math

Math package contains the most general math utilities: vectors,
matrices, etc.

- vectors: 2D, 3D, 4D (gml::TVector2, gml::TVector3, gml::TVector4)
- matrices: 2x2, 3x3, 4x4 (gml::TMatrix2x2, gml::TMatrix3x3, gml::TMatrix4x4)
- quaternions (gml::TQuaternion)
- bounding boxes (2D, 3D) and bounding spheres  (gml::BBox2, gml::BBox2,
  gml::BSphere3)

The library was designed independent on particular compiler, though
currently we assume Win32 platform. It uses neigher MFC nor VCL or any
other popular API. At the same time there is preprocessor switches that
allow integration of GML data types with MFC/VCL data types.

The library uses STL and assumes STL usage by the programmer (though
it is not a necessary condition)

\subsection color Color

Color package defines gml::TColor3 and gml::TColor4 clases
that represent color values.

\subsection files Files

Files package defines some common utilities to work with filesystem:

- gml::File provides an object-oriented way to read & write to
  text and finary files (FILE* wrapper)
- gml::PathString to parse strings containing file & path names
- gml::FileFinder used to enumerate files directories
- CIniFile provides facility for loading & saving of INI-files

\subsection image Images

This is the most complete package so far. It defines several
classes to work with different kinds of images, apply filters, etc.

- gml::Image is a base class, it has several descendant, like 
  gml::SimpleImage, gml::IntelImage, gml::GDIImage
- filters can be applied to any image independent of its type
  Many filters have been implemented: blurring, color conversion,
  resizing, etc
- Images can loaded/saved in multiple formats 
  using either internal interface or external library FreeImage.

\subsection net Net

Net package defines single class gml::Socket, which is a simple
wrapper over standart sockets functionality.


\subsection utils3d Utils3D

This package have some classes, useful for developing 3D graphics
application independent on different APIs like OpenGL or DirectX.

- gml::Camera and gml::Viewport classes
- gml::Browser class is a helper for navigation through a 3D scene
- gml::FrameCounter allow to calculate average frame rates (FPS)
- also several utility functions available.


\subsection utilsGL UtilsGL

UtilsGL contains some useful utilities for OpenGL programming:

- OpenGL extentions handling (taken from NVidia SDK)
- OGL Win32 context management (gml::GLRC)

GML Common Source Library is contastantly evolving, so all the
packages are updated frequently.

\section install Installing and Usage

- Unpack the archive
- Link with necessary packages (depends on functionalities you
  are going to use). Note: all the packages depend on Base and
  on Math
- The header <CSL/base/gmlcommon.h> must be included before
  any other includes of GML files. It usually worth to
  include this file into precompiled headers list (stdafx.h for
  MSVC)


*/