//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlsmartobject.h,v 1.5 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifndef _GMLSMARTOBJECT_H_
#define _GMLSMARTOBJECT_H_

/** @file
 *  @brief Definitions of smart object (which supports smart references)
 *
 */

namespace gml
{
  /** @addtogroup Base
   *  @{
   */

  /// @brief Base class for objects with support for reference counting
  /// @sa gml::Ref
  class SmartObject
  {
    public:
      SmartObject() : m_ref_count(0)
      {
      }


      /// @brief Increment reference count
      /// @warning This function is used internally, you should never call it
      void AddRef()
      {
        ++m_ref_count;
      }

      /// @brief Decrement reference count
      /// @warning This function is used internally, you should never call it
      void Release()
      {
        if (--m_ref_count == 0)
          delete this;
      }

      /// Destructor is virtual
      virtual ~SmartObject()
      {
      }

    private:
      int m_ref_count;
  };

  /** @} */
}    

#endif