//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlmethodcallback.h,v 1.6 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifndef _GMLMETHODCALLBACK_H_
#define _GMLMETHODCALLBACK_H_

#include "gmlcallback.h"

namespace gml
{
  /** @addtogroup Base
   *  @{
   */


  template <class CLASS>
  class  MethodCallback : public Callback
  {
      /**<  Callback-wrapper for a C++-method of a class CLASS
      with no arguments and no return value:
      void CLASS::func();
      void CLASS::func() const; */
    public: 
      typedef void (CLASS::*ConstMethod)() const;

      MethodCallback(CLASS* obj, void (CLASS::* meth) ()) : obj_(obj),
                                                            meth_((ConstMethod)
                                                                  meth)
      {
        ASSERT(obj);
        ASSERT(meth);
      }
      MethodCallback(const CLASS* obj, void (CLASS::* meth) () const) : obj_(obj),
                                                                        meth_(meth)
      {
        ASSERT(obj);
        ASSERT(meth);
      }
      /**<  The c'tor expects a pointer to an object of type CLASS
      and a method-pointer to a method of the appropriate type.
      Non-const- and const-methods are supported!
      Note that the object-pointer will be stored in a normal
      pointer (not a SO<CLASS>-pointer)! */

      virtual void Call()
      {
        (obj_->*meth_) ();
      }
      //!<  See Callback::callback.



    private:
      const CLASS* obj_;
      void (CLASS::*meth_)() const;
  };

  template <class CLASS, class RETURN>
  class  MethodCallbackR : public CallbackR<RETURN>
  {
      /**<  Callback-wrapper for a C++-method of a class CLASS
      with no arguments and a return value of type RETURN:
      RETURN CLASS::func();
      RETURN CLASS::func() const; */
    public:
      typedef RETURN (CLASS::*ConstMethod)() const;

      MethodCallbackR(CLASS* obj, RETURN(CLASS::* meth)()) : obj_(obj),
                                                             meth_((ConstMethod)
                                                                   meth)
      {
        ASSERT(obj);
        ASSERT(meth);
      }
      MethodCallbackR(const CLASS* obj, RETURN(CLASS::* meth)() const) : obj_(obj),
                                                                         meth_(meth)
      {
        ASSERT(obj);
        ASSERT(meth);
      }
      /**<  The c'tor expects a pointer to an object of type CLASS
      and a method-pointer to a method of the appropriate type.
      Non-const- and const-methods are supported!
      Note that the object-pointer will be stored in a normal
      pointer (not a SO<CLASS>-pointer)! */

      virtual RETURN Call()
      {
        return (obj_->*meth_) ();
      }
      //!<  See CallbackR::callback.


    private:
      const CLASS* obj_;
      RETURN (CLASS::*meth_)() const;
  };

  template <class CLASS, class ARG1>
  class  MethodCallback1 : public Callback1<ARG1>
  {
      /**<  Callback-wrapper for a C++-method of a class CLASS
      with one argument of type ARG1 and no return value:
      void CLASS::func(ARG1 arg1);
      void CLASS::func(ARG1 arg1) const; */
    public:
      typedef void (CLASS::*ConstMethod)(ARG1) const;

      MethodCallback1(CLASS* obj, void (CLASS::* meth) (ARG1)) : obj_(obj),
                                                                 meth_((ConstMethod)
                                                                       meth)
      {
        ASSERT(obj);
        ASSERT(meth);
      }
      MethodCallback1(const CLASS* obj, void (CLASS::* meth) (ARG1) const) : obj_(obj),
                                                                             meth_(meth)
      {
        ASSERT(obj);
        ASSERT(meth);
      }
      /**<  The c'tor expects a pointer to an object of type CLASS
      and a method-pointer to a method of the appropriate type.
      Non-const- and const-methods are supported!
      Note that the object-pointer will be stored in a normal
      pointer (not a SO<CLASS>-pointer)! */

      virtual void Call(ARG1 arg1)
      {
        (obj_->*meth_) (arg1);
      }
      //!<  See Callback1::callback.



    private:
      const CLASS* obj_;
      void (CLASS::*meth_)(ARG1) const;
  };

  template <class CLASS, class RETURN, class ARG1>
  class  MethodCallbackR1 : public CallbackR1<RETURN, ARG1>
  {
      /**<  Callback-wrapper for a C++-method of a class CLASS
      with one argument of type ARG1 and a return value
      of type RETURN:
      RETURN CLASS::func(ARG1 arg1);
      RETURN CLASS::func(ARG1 arg1) const; */
    public:
      typedef RETURN (CLASS::*ConstMethod)(ARG1) const;

      MethodCallbackR1(CLASS* obj, RETURN(CLASS::* meth)(ARG1)) : obj_(obj),
                                                                  meth_((ConstMethod)
                                                                        meth)
      {
        ASSERT(obj);
        ASSERT(meth);
      }
      MethodCallbackR1(const CLASS* obj, RETURN(CLASS::* meth)(ARG1) const) : obj_(obj),
                                                                              meth_(meth)
      {
        ASSERT(obj);
        ASSERT(meth);
      }
      /**<  The c'tor expects a pointer to an object of type CLASS
      and a method-pointer to a method of the appropriate type.
      Non-const- and const-methods are supported!
      Note that the object-pointer will be stored in a normal
      pointer (not a SO<CLASS>-pointer)! */

      virtual RETURN Call(ARG1 arg1)
      {
        return (obj_->*meth_) (arg1);
      }
      //!<  See CallbackR1::callback.



    private:
      const CLASS* obj_;
      RETURN (CLASS::*meth_)(ARG1) const;
  };

  template <class CLASS, class ARG1, class ARG2>
  class  MethodCallback2 : public Callback2<ARG1, ARG2>
  {
      /**<  Callback-wrapper for a C++-method of a class CLASS
      with two arguments of type ARG1 and ARG2 and no return value:
      void CLASS::func(ARG1 arg1, ARG2 arg2);
      void CLASS::func(ARG1 arg1, ARG2 arg2) const; */
    public:
      typedef void (CLASS::*ConstMethod)(ARG1, ARG2) const;

      MethodCallback2(CLASS* obj, void (CLASS::* meth) (ARG1, ARG2)) : obj_(obj),
                                                                       meth_((ConstMethod)
                                                                             meth)
      {
        ASSERT(obj);
        ASSERT(meth);
      }
      MethodCallback2(const CLASS* obj,
                      void (CLASS::* meth) (ARG1, ARG2) const) : obj_(obj),
                                                                 meth_(meth)
      {
        ASSERT(obj);
        ASSERT(meth);
      }
      /**<  The c'tor expects a pointer to an object of type CLASS
      and a method-pointer to a method of the appropriate type.
      Non-const- and const-methods are supported!
      Note that the object-pointer will be stored in a normal
      pointer (not a SO<CLASS>-pointer)! */

      virtual void Call(ARG1 arg1, ARG2 arg2)
      {
        (obj_->*meth_) (arg1, arg2);
      }
      //!<  See Callback2::callback.


    private:
      const CLASS* obj_;
      void (CLASS::*meth_)(ARG1, ARG2) const;
  };

  template <class CLASS, class RETURN, class ARG1, class ARG2>
  class  MethodCallbackR2 : public CallbackR2<RETURN, ARG1, ARG2>
  {
      /**<  Callback-wrapper for a C++-method of a class CLASS
      with two arguments of type ARG1 and ARG2 and a return
      value of type RETURN:
      RETURN CLASS::func(ARG1 arg1, ARG2 arg2);
      RETURN CLASS::func(ARG1 arg1, ARG2 arg2) const; */
    public:
      typedef RETURN (CLASS::*ConstMethod)(ARG1, ARG2) const;

      MethodCallbackR2(CLASS* obj, RETURN(CLASS::* meth)(ARG1, ARG2)) : obj_(obj),
                                                                        meth_((ConstMethod)
                                                                              meth)
      {
        ASSERT(obj);
        ASSERT(meth);
      }
      MethodCallbackR2(const CLASS* obj,
                       RETURN(CLASS::* meth)(ARG1, ARG2) const) : obj_(obj),
                                                                  meth_(meth)
      {
        ASSERT(obj);
        ASSERT(meth);
      }
      /**<  The c'tor expects a pointer to an object of type CLASS
      and a method-pointer to a method of the appropriate type.
      Non-const- and const-methods are supported!
      Note that the object-pointer will be stored in a normal
      pointer (not a SO<CLASS>-pointer)! */

      virtual RETURN Call(ARG1 arg1, ARG2 arg2)
      {
        return (obj_->*meth_) (arg1, arg2);
      }
      //!<  See CallbackR2::callback.


    private:
      const CLASS* obj_;
      RETURN (CLASS::*meth_)(ARG1, ARG2) const;
  };

  template <class CLASS, class ARG1, class ARG2, class ARG3>
  class  MethodCallback3 : public Callback3<ARG1, ARG2, ARG3>
  {
      /**<  Callback-wrapper for a C++-method of a class CLASS
      with three arguments of type ARG1, ARG2, and ARG3 and no return value:
      void CLASS::func(ARG1 arg1, ARG2 arg2, ARG3 arg3);
      void CLASS::func(ARG1 arg1, ARG2 arg2, ARG3 arg3) const; */
    public:
      typedef void (CLASS::*ConstMethod)(ARG1, ARG2, ARG3) const;

      MethodCallback3(CLASS* obj, void (CLASS::* meth) (ARG1, ARG2, ARG3)) : obj_(obj),
                                                                             meth_((ConstMethod)
                                                                                   meth)
      {
        ASSERT(obj);
        ASSERT(meth);
      }
      MethodCallback3(const CLASS* obj,
                      void (CLASS::* meth) (ARG1, ARG2, ARG3) const) : obj_(obj),
                                                                       meth_(meth)
      {
        ASSERT(obj);
        ASSERT(meth);
      }
      /**<  The c'tor expects a pointer to an object of type CLASS
      and a method-pointer to a method of the appropriate type.
      Non-const- and const-methods are supported!
      Note that the object-pointer will be stored in a normal
      pointer (not a SO<CLASS>-pointer)! */

      virtual void Call(ARG1 arg1, ARG2 arg2, ARG3 arg3)
      {
        (obj_->*meth_) (arg1, arg2, arg3);
      }
      //!<  See Callback3::callback.


    private:
      const CLASS* obj_;
      void (CLASS::*meth_)(ARG1, ARG2, ARG3) const;
  };

  template <class CLASS, class RETURN, class ARG1, class ARG2, class ARG3>
  class  MethodCallbackR3 : public CallbackR3<RETURN, ARG1, ARG2, ARG3>
  {
      /**<  Callback-wrapper for a C++-method of a class CLASS
      with three arguments of type ARG1, ARG2, and ARG3 and a return
      value of type RETURN:
      RETURN CLASS::func(ARG1 arg1, ARG2 arg2, ARG3 arg3);
      RETURN CLASS::func(ARG1 arg1, ARG2 arg2, ARG3 arg3) const; */
    public:
      typedef RETURN (CLASS::*ConstMethod)(ARG1, ARG2, ARG3) const;

      MethodCallbackR3(CLASS* obj, RETURN(CLASS::* meth)(ARG1, ARG2, ARG3)) : obj_(obj),
                                                                              meth_((ConstMethod)
                                                                                    meth)
      {
        ASSERT(obj);
        ASSERT(meth);
      }
      MethodCallbackR3(const CLASS* obj,
                       RETURN(CLASS::* meth)(ARG1, ARG2, ARG3) const) : obj_(obj),
                                                                        meth_(meth)
      {
        ASSERT(obj);
        ASSERT(meth);
      }
      /**<  The c'tor expects a pointer to an object of type CLASS
      and a method-pointer to a method of the appropriate type.
      Non-const- and const-methods are supported!
      Note that the object-pointer will be stored in a normal
      pointer (not a SO<CLASS>-pointer)! */

      virtual RETURN Call(ARG1 arg1, ARG2 arg2, ARG3 arg3)
      {
        return (obj_->*meth_) (arg1, arg2, arg3);
      }
      //!<  See CallbackR2::callback.


    private:
      const CLASS* obj_;
      RETURN (CLASS::*meth_)(ARG1, ARG2, ARG3) const;
  };


#if 0
    template<class CLASS>
    inline Callback* makeCallback(CLASS* obj, void (CLASS::*meth)()) {
    return new MethodCallback<CLASS>(obj, meth);
    }
  
  template<class CLASS>
    inline Callback* makeCallback(CLASS* obj, void (CLASS::*meth)() const) {
    return new MethodCallback<CLASS>(obj, meth);
    }
  
  template<class CLASS, class RETURN>
    inline CallbackR<RETURN>* makeCallbackWithReturn(CLASS* obj, RETURN (CLASS::*meth)()) {
    return new MethodCallbackR<CLASS, RETURN>(obj, meth);
    }
  
  template<class CLASS, class RETURN>
    inline CallbackR<RETURN>* makeCallbackWithReturn(CLASS* obj, RETURN (CLASS::*meth)() const) {
    return new MethodCallbackR<CLASS, RETURN>(obj, meth);
    }
  
  
  template<class CLASS, class ARG1>
    inline Callback1<ARG1>* makeCallback(CLASS* obj, void (CLASS::*meth)(ARG1)) {
    return new MethodCallback1<CLASS, ARG1>(obj, meth);
    }
  
  template<class CLASS, class ARG1>
    inline Callback1<ARG1>* makeCallback(CLASS* obj, void (CLASS::*meth)(ARG1) const) {
    return new MethodCallback1<CLASS, ARG1>(obj, meth);
    }
  
  template<class CLASS, class RETURN, class ARG1>
    inline CallbackR1<RETURN, ARG1>* makeCallbackWithReturn(CLASS* obj, RETURN (CLASS::*meth)(ARG1)) {
    return new MethodCallbackR1<CLASS, RETURN, ARG1>(obj, meth);
    }
  
  template<class CLASS, class RETURN, class ARG1>
    inline CallbackR1<RETURN, ARG1>* makeCallbackWithReturn(CLASS* obj, RETURN (CLASS::*meth)(ARG1) const) {
    return new MethodCallbackR1<CLASS, RETURN, ARG1>(obj, meth);
    }
  
  
  
  template<class CLASS, class ARG1, class ARG2>
    inline Callback2<ARG1, ARG2>* makeCallback(CLASS* obj, void (CLASS::*meth)(ARG1, ARG2)) {
    return new MethodCallback2<CLASS, ARG1, ARG2>(obj, meth);
    }
  
  template<class CLASS, class ARG1, class ARG2>
    inline Callback2<ARG1, ARG2>* makeCallback(CLASS* obj, void (CLASS::*meth)(ARG1, ARG2) const) {
    return new MethodCallback2<CLASS, ARG1, ARG2>(obj, meth);
    }
  
  template<class CLASS, class RETURN, class ARG1, class ARG2>
    inline CallbackR2<RETURN, ARG1, ARG2>* makeCallbackWithReturn(CLASS* obj, RETURN (CLASS::*meth)(ARG1, ARG2)) {
    return new MethodCallbackR2<CLASS, RETURN, ARG1, ARG2>(obj, meth);
    }
  
  template<class CLASS, class RETURN, class ARG1, class ARG2>
    inline CallbackR2<RETURN, ARG1, ARG2>* makeCallbackWithReturn(CLASS* obj, RETURN (CLASS::*meth)(ARG1, ARG2) const) {
    return new MethodCallbackR2<CLASS, RETURN, ARG1, ARG2>(obj, meth);
    }
  
  
  template<class CLASS, class ARG1, class ARG2, class ARG3>
    inline Callback3<ARG1, ARG2, ARG3>* makeCallback(CLASS* obj, void (CLASS::*meth)(ARG1, ARG2, ARG3)) {
    return new MethodCallback3<CLASS, ARG1, ARG2, ARG3>(obj, meth);
    }
  
  template<class CLASS, class ARG1, class ARG2, class ARG3>
    inline Callback3<ARG1, ARG2, ARG3>* makeCallback(CLASS* obj, void (CLASS::*meth)(ARG1, ARG2, ARG3) const) {
    return new MethodCallback3<CLASS, ARG1, ARG2, ARG3>(obj, meth);
    }
  
  template<class CLASS, class RETURN, class ARG1, class ARG2, class ARG3>
    inline CallbackR3<RETURN, ARG1, ARG2, ARG3>* makeCallbackWithReturn(CLASS* obj, RETURN (CLASS::*meth)(ARG1, ARG2, ARG3)) {
    return new MethodCallbackR3<CLASS, RETURN, ARG1, ARG2, ARG3>(obj, meth);
    }
  
  template<class CLASS, class RETURN, class ARG1, class ARG2, class ARG3>
    inline CallbackR3<RETURN, ARG1, ARG2, ARG3>* makeCallbackWithReturn(CLASS* obj, RETURN (CLASS::*meth)(ARG1, ARG2, ARG3) const) {
    return new MethodCallbackR3<CLASS, RETURN, ARG1, ARG2, ARG3>(obj, meth);
    }
#endif  


  /** @} */
}

#endif