//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlcommon.h,v 1.14 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.

#ifndef _GMLCOMMON_H_INCLUDED 
#define _GMLCOMMON_H_INCLUDED 

/** @file gmlcommon.h
 *  @brief General routines like ASSERT etc.
 */

#include <assert.h>

#ifdef _MSC_VER
// disable warning C4786: symbol greater than 255 character,
// disable warning C4386: identifier was truncated to '255' characters in the debug information
// okay to ignore
#pragma warning(disable : 4786 4386)

#endif

/// custom assertion (DEBUG mode only)

#ifdef _DEBUG
#ifndef ASSERT
#define ASSERT(expr) assert(expr);
#endif
#define VERIFY(f)    ASSERT(f)
#else
#ifndef ASSERT
#define ASSERT(expr)
#endif
#define VERIFY(f)    ((void)(f))
#endif

#define NULL 0

typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;

namespace gml
{
  /** @addtogroup Base
   *  @{
   */


  /* @} */
}



#endif