//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlmesh.h,v 1.5 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.


#ifndef _GMLMESH_H_INCLUDED 
#define _GMLMESH_H_INCLUDED 

/** @file
 *  @brief Definition of gml::Mesh class
 */


// CSL includes

#include "../base/gmlsmartobject.h"
#include "../color/gmlcolor.h"
#include "../math/gmlvector2.h"
#include "../math/gmlvector3.h"


// std includes
#include <vector>

namespace gml
{
  /** @addtogroup 3DScene
   *  @{
   */

  class Mesh : public gml::SmartObject
  {
    public:

      Mesh() : created(false)
      {
      }
      virtual ~Mesh();

      bool Create(int n_trgs,
                  int n_verts,
                  bool has_vnorms = true,
                  bool has_vcolors = true,
                  bool has_tcoords = true);


      int NVertices() const
      {
        return vertices.size();
      }

      int NTrgs() const
      {
        return trgs.size();
      }

      const Vector3f* Vertices() const
      {
        return &vertices[0];
      }

      const Vector3i* Trgs() const
      {
        return &trgs[0];
      }

      const Vector3f* VNormals() const
      {
        return &vnorms[0];
      }

      const Vector2f* TCoords() const
      {
        return &tcoords[0];
      }

      const Color3ub* VColors() const
      {
        return &vcolors[0];
      }


      Vector3f* Vertices()
      {
        return &vertices[0];
      }

      Vector3i* Trgs()
      {
        return &trgs[0];
      }

      Vector3f* VNormals()
      {
        return &vnorms[0];
      }

      Vector2f* TCoords()
      {
        return &tcoords[0];
      }

      Color3ub* VColors()
      {
        return &vcolors[0];
      }


    private:
      std::vector<Vector3f> vertices;
      std::vector<Vector3i> trgs;
      std::vector<Vector3f> vnorms;
      std::vector<Vector2f> tcoords;
      std::vector<Color3ub> vcolors;
      bool created;
  };

  /* @} */
}


#endif