//
//  GMlib -- Graphics & Media Lab Common Source Library
//
//  $Id: gmlmesh.cpp,v 1.5 2004/01/13 17:38:42 04a_deg Exp $
//
//  Copyright (C) 2004, Moscow State University Graphics & Media Lab
//  gmlsupport@graphics.cs.msu.su
//  
//  This file is part of GMlib software.
//  For conditions of distribution and use, see the accompanying README file.


#include "../base/gmlcommon.h"
#include "gmlmesh.h"


bool gml::Mesh::Create(int n_trgs,
                       int n_verts,
                       bool has_vnorms /* = true */,
                       bool has_vcolors /* = true */,
                       bool has_tcoords /* = true */)
{
  ASSERT(n_trgs > 0);
  ASSERT(n_verts > 0);

  vertices.resize(n_verts);
  trgs.resize(n_trgs);

  if (has_vnorms)
    vnorms.resize(n_verts);

  if (has_vcolors)
    vcolors.resize(n_verts);

  if (has_tcoords)
    tcoords.resize(n_verts);

  return true;
}